/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ASSET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/assets/{asset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String asset;

    @Deprecated
    protected AssetName() {
        this.project = null;
        this.location = null;
        this.asset = null;
    }

    private AssetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAsset() {
        return this.asset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetName of(String project, String location, String asset) {
        return AssetName.newBuilder().setProject(project).setLocation(location).setAsset(asset).build();
    }

    public static String format(String project, String location, String asset) {
        return AssetName.newBuilder().setProject(project).setLocation(location).setAsset(asset).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ASSET.validatedMatch(formattedString, "AssetName.parse: formattedString not in valid format");
        return AssetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("asset"));
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ASSET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ASSET.instantiate(new String[]{"project", this.project, "location", this.location, "asset", this.asset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AssetName that = (AssetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.asset, that.asset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.asset);
    }

    public static class Builder {
        private String project;
        private String location;
        private String asset;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(AssetName assetName) {
            this.project = assetName.project;
            this.location = assetName.location;
            this.asset = assetName.asset;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

