/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConferenceRecordName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;

    @Deprecated
    protected ConferenceRecordName() {
        this.conferenceRecord = null;
    }

    private ConferenceRecordName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConferenceRecordName of(String conferenceRecord) {
        return ConferenceRecordName.newBuilder().setConferenceRecord(conferenceRecord).build();
    }

    public static String format(String conferenceRecord) {
        return ConferenceRecordName.newBuilder().setConferenceRecord(conferenceRecord).build().toString();
    }

    public static ConferenceRecordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD.validatedMatch(formattedString, "ConferenceRecordName.parse: formattedString not in valid format");
        return ConferenceRecordName.of((String)matchMap.get("conference_record"));
    }

    public static List<ConferenceRecordName> parseList(List<String> formattedStrings) {
        ArrayList<ConferenceRecordName> list = new ArrayList<ConferenceRecordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConferenceRecordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConferenceRecordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConferenceRecordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConferenceRecordName conferenceRecordName = this;
            synchronized (conferenceRecordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD.instantiate(new String[]{"conference_record", this.conferenceRecord});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConferenceRecordName that = (ConferenceRecordName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.conferenceRecord);
    }

    public static class Builder {
        private String conferenceRecord;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        private Builder(ConferenceRecordName conferenceRecordName) {
            this.conferenceRecord = conferenceRecordName.conferenceRecord;
        }

        public ConferenceRecordName build() {
            return new ConferenceRecordName(this);
        }
    }
}

