/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MemberName
implements ResourceName {
    private static final PathTemplate SPACE_MEMBER = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}/members/{member}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;
    private final String member;

    @Deprecated
    protected MemberName() {
        this.space = null;
        this.member = null;
    }

    private MemberName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.member = (String)Preconditions.checkNotNull((Object)builder.getMember());
    }

    public String getSpace() {
        return this.space;
    }

    public String getMember() {
        return this.member;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MemberName of(String space, String member) {
        return MemberName.newBuilder().setSpace(space).setMember(member).build();
    }

    public static String format(String space, String member) {
        return MemberName.newBuilder().setSpace(space).setMember(member).build().toString();
    }

    public static MemberName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE_MEMBER.validatedMatch(formattedString, "MemberName.parse: formattedString not in valid format");
        return MemberName.of((String)matchMap.get("space"), (String)matchMap.get("member"));
    }

    public static List<MemberName> parseList(List<String> formattedStrings) {
        ArrayList<MemberName> list = new ArrayList<MemberName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MemberName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MemberName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MemberName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE_MEMBER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MemberName memberName = this;
            synchronized (memberName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.member != null) {
                        fieldMapBuilder.put((Object)"member", (Object)this.member);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE_MEMBER.instantiate(new String[]{"space", this.space, "member", this.member});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MemberName that = (MemberName)o;
            return Objects.equals(this.space, that.space) && Objects.equals(this.member, that.member);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        return h ^= Objects.hashCode(this.member);
    }

    public static class Builder {
        private String space;
        private String member;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public String getMember() {
            return this.member;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setMember(String member) {
            this.member = member;
            return this;
        }

        private Builder(MemberName memberName) {
            this.space = memberName.space;
            this.member = memberName.member;
        }

        public MemberName build() {
            return new MemberName(this);
        }
    }
}

