/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AclName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_ACL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/acls/{acl}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String acl;

    @Deprecated
    protected AclName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.acl = null;
    }

    private AclName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.acl = (String)Preconditions.checkNotNull((Object)builder.getAcl());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getAcl() {
        return this.acl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AclName of(String project, String location, String cluster, String acl) {
        return AclName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setAcl(acl).build();
    }

    public static String format(String project, String location, String cluster, String acl) {
        return AclName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setAcl(acl).build().toString();
    }

    public static AclName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_ACL.validatedMatch(formattedString, "AclName.parse: formattedString not in valid format");
        return AclName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("acl"));
    }

    public static List<AclName> parseList(List<String> formattedStrings) {
        ArrayList<AclName> list = new ArrayList<AclName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AclName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AclName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AclName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_ACL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AclName aclName = this;
            synchronized (aclName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.acl != null) {
                        fieldMapBuilder.put((Object)"acl", (Object)this.acl);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_ACL.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "acl", this.acl});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AclName that = (AclName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.acl, that.acl);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.acl);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String acl;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getAcl() {
            return this.acl;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setAcl(String acl) {
            this.acl = acl;
            return this;
        }

        private Builder(AclName aclName) {
            this.project = aclName.project;
            this.location = aclName.location;
            this.cluster = aclName.cluster;
            this.acl = aclName.acl;
        }

        public AclName build() {
            return new AclName(this);
        }
    }
}

