/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONNECT_CLUSTER_CONNECTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connectClusters/{connect_cluster}/connectors/{connector}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String connectCluster;
    private final String connector;

    @Deprecated
    protected ConnectorName() {
        this.project = null;
        this.location = null;
        this.connectCluster = null;
        this.connector = null;
    }

    private ConnectorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connectCluster = (String)Preconditions.checkNotNull((Object)builder.getConnectCluster());
        this.connector = (String)Preconditions.checkNotNull((Object)builder.getConnector());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnectCluster() {
        return this.connectCluster;
    }

    public String getConnector() {
        return this.connector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConnectorName of(String project, String location, String connectCluster, String connector) {
        return ConnectorName.newBuilder().setProject(project).setLocation(location).setConnectCluster(connectCluster).setConnector(connector).build();
    }

    public static String format(String project, String location, String connectCluster, String connector) {
        return ConnectorName.newBuilder().setProject(project).setLocation(location).setConnectCluster(connectCluster).setConnector(connector).build().toString();
    }

    public static ConnectorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONNECT_CLUSTER_CONNECTOR.validatedMatch(formattedString, "ConnectorName.parse: formattedString not in valid format");
        return ConnectorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connect_cluster"), (String)matchMap.get("connector"));
    }

    public static List<ConnectorName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectorName> list = new ArrayList<ConnectorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONNECT_CLUSTER_CONNECTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectorName connectorName = this;
            synchronized (connectorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.connectCluster != null) {
                        fieldMapBuilder.put((Object)"connect_cluster", (Object)this.connectCluster);
                    }
                    if (this.connector != null) {
                        fieldMapBuilder.put((Object)"connector", (Object)this.connector);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONNECT_CLUSTER_CONNECTOR.instantiate(new String[]{"project", this.project, "location", this.location, "connect_cluster", this.connectCluster, "connector", this.connector});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectorName that = (ConnectorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.connectCluster, that.connectCluster) && Objects.equals(this.connector, that.connector);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.connectCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.connector);
    }

    public static class Builder {
        private String project;
        private String location;
        private String connectCluster;
        private String connector;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnectCluster() {
            return this.connectCluster;
        }

        public String getConnector() {
            return this.connector;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnectCluster(String connectCluster) {
            this.connectCluster = connectCluster;
            return this;
        }

        public Builder setConnector(String connector) {
            this.connector = connector;
            return this;
        }

        private Builder(ConnectorName connectorName) {
            this.project = connectorName.project;
            this.location = connectorName.location;
            this.connectCluster = connectorName.connectCluster;
            this.connector = connectorName.connector;
        }

        public ConnectorName build() {
            return new ConnectorName(this);
        }
    }
}

