// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_metrics.proto

package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes a logs-based metric. The value of the metric is the number of log
 * entries that match a logs filter in a given time interval.
 * Logs-based metric can also be used to extract values from logs and create a
 * a distribution of the values. The distribution records the statistics of the
 * extracted values along with an optional histogram of the values as specified
 * by the bucket options.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.LogMetric}
 */
public final class LogMetric extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.LogMetric)
    LogMetricOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogMetric.newBuilder() to construct.
  private LogMetric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogMetric() {
    name_ = "";
    description_ = "";
    filter_ = "";
    valueExtractor_ = "";
    version_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LogMetric(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              filter_ = s;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              version_ = rawValue;
              break;
            }
          case 42:
            {
              com.google.api.MetricDescriptor.Builder subBuilder = null;
              if (metricDescriptor_ != null) {
                subBuilder = metricDescriptor_.toBuilder();
              }
              metricDescriptor_ =
                  input.readMessage(com.google.api.MetricDescriptor.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metricDescriptor_);
                metricDescriptor_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();

              valueExtractor_ = s;
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000020) != 0)) {
                labelExtractors_ =
                    com.google.protobuf.MapField.newMapField(
                        LabelExtractorsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000020;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
                  input.readMessage(
                      LabelExtractorsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              labelExtractors_
                  .getMutableMap()
                  .put(labelExtractors__.getKey(), labelExtractors__.getValue());
              break;
            }
          case 66:
            {
              com.google.api.Distribution.BucketOptions.Builder subBuilder = null;
              if (bucketOptions_ != null) {
                subBuilder = bucketOptions_.toBuilder();
              }
              bucketOptions_ =
                  input.readMessage(
                      com.google.api.Distribution.BucketOptions.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(bucketOptions_);
                bucketOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 82:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingMetricsProto
        .internal_static_google_logging_v2_LogMetric_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabelExtractors();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingMetricsProto
        .internal_static_google_logging_v2_LogMetric_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.LogMetric.class, com.google.logging.v2.LogMetric.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Logging API version.
   * </pre>
   *
   * Protobuf enum {@code google.logging.v2.LogMetric.ApiVersion}
   */
  public enum ApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Logging API v2.
     * </pre>
     *
     * <code>V2 = 0;</code>
     */
    V2(0),
    /**
     *
     *
     * <pre>
     * Logging API v1.
     * </pre>
     *
     * <code>V1 = 1;</code>
     */
    V1(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Logging API v2.
     * </pre>
     *
     * <code>V2 = 0;</code>
     */
    public static final int V2_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Logging API v1.
     * </pre>
     *
     * <code>V1 = 1;</code>
     */
    public static final int V1_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static ApiVersion valueOf(int value) {
      return forNumber(value);
    }

    public static ApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return V2;
        case 1:
          return V1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApiVersion>() {
          public ApiVersion findValueByNumber(int number) {
            return ApiVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.logging.v2.LogMetric.getDescriptor().getEnumTypes().get(0);
    }

    private static final ApiVersion[] VALUES = values();

    public static ApiVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.logging.v2.LogMetric.ApiVersion)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The client-assigned metric identifier.
   * Examples: `"error_count"`, `"nginx/requests"`.
   * Metric identifiers are limited to 100 characters and can include only the
   * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
   * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
   * name pieces, and it cannot be the first character of the name.
   * The metric identifier in this field must not be
   * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
   * However, when the metric identifier appears as the `[METRIC_ID]` part of a
   * `metric_name` API parameter, then the metric identifier must be
   * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The client-assigned metric identifier.
   * Examples: `"error_count"`, `"nginx/requests"`.
   * Metric identifiers are limited to 100 characters and can include only the
   * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
   * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
   * name pieces, and it cannot be the first character of the name.
   * The metric identifier in this field must not be
   * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
   * However, when the metric identifier appears as the `[METRIC_ID]` part of a
   * `metric_name` API parameter, then the metric identifier must be
   * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. A description of this metric, which is used in documentation.
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of this metric, which is used in documentation.
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 3;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
   * which is used to match log entries.
   * Example:
   *     "resource.type=gae_app AND severity&gt;=ERROR"
   * The maximum length of the filter is 20000 characters.
   * </pre>
   *
   * <code>string filter = 3;</code>
   */
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
   * which is used to match log entries.
   * Example:
   *     "resource.type=gae_app AND severity&gt;=ERROR"
   * The maximum length of the filter is 20000 characters.
   * </pre>
   *
   * <code>string filter = 3;</code>
   */
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_DESCRIPTOR_FIELD_NUMBER = 5;
  private com.google.api.MetricDescriptor metricDescriptor_;
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
   */
  public boolean hasMetricDescriptor() {
    return metricDescriptor_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
   */
  public com.google.api.MetricDescriptor getMetricDescriptor() {
    return metricDescriptor_ == null
        ? com.google.api.MetricDescriptor.getDefaultInstance()
        : metricDescriptor_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
   */
  public com.google.api.MetricDescriptorOrBuilder getMetricDescriptorOrBuilder() {
    return getMetricDescriptor();
  }

  public static final int VALUE_EXTRACTOR_FIELD_NUMBER = 6;
  private volatile java.lang.Object valueExtractor_;
  /**
   *
   *
   * <pre>
   * Optional. A `value_extractor` is required when using a distribution
   * logs-based metric to extract the values to record from a log entry.
   * Two functions are supported for value extraction: `EXTRACT(field)` or
   * `REGEXP_EXTRACT(field, regex)`. The argument are:
   *   1. field: The name of the log entry field from which the value is to be
   *      extracted.
   *   2. regex: A regular expression using the Google RE2 syntax
   *      (https://github.com/google/re2/wiki/Syntax) with a single capture
   *      group to extract data from the specified log entry field. The value
   *      of the field is converted to a string before applying the regex.
   *      It is an error to specify a regex that does not include exactly one
   *      capture group.
   * The result of the extraction must be convertible to a double type, as the
   * distribution always records double values. If either the extraction or
   * the conversion to double fails, then those values are not recorded in the
   * distribution.
   * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
   * </pre>
   *
   * <code>string value_extractor = 6;</code>
   */
  public java.lang.String getValueExtractor() {
    java.lang.Object ref = valueExtractor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      valueExtractor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A `value_extractor` is required when using a distribution
   * logs-based metric to extract the values to record from a log entry.
   * Two functions are supported for value extraction: `EXTRACT(field)` or
   * `REGEXP_EXTRACT(field, regex)`. The argument are:
   *   1. field: The name of the log entry field from which the value is to be
   *      extracted.
   *   2. regex: A regular expression using the Google RE2 syntax
   *      (https://github.com/google/re2/wiki/Syntax) with a single capture
   *      group to extract data from the specified log entry field. The value
   *      of the field is converted to a string before applying the regex.
   *      It is an error to specify a regex that does not include exactly one
   *      capture group.
   * The result of the extraction must be convertible to a double type, as the
   * distribution always records double values. If either the extraction or
   * the conversion to double fails, then those values are not recorded in the
   * distribution.
   * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
   * </pre>
   *
   * <code>string value_extractor = 6;</code>
   */
  public com.google.protobuf.ByteString getValueExtractorBytes() {
    java.lang.Object ref = valueExtractor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      valueExtractor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_EXTRACTORS_FIELD_NUMBER = 7;

  private static final class LabelExtractorsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.logging.v2.LoggingMetricsProto
                .internal_static_google_logging_v2_LogMetric_LabelExtractorsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetLabelExtractors() {
    if (labelExtractors_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          LabelExtractorsDefaultEntryHolder.defaultEntry);
    }
    return labelExtractors_;
  }

  public int getLabelExtractorsCount() {
    return internalGetLabelExtractors().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   * The extracted value is converted to the type defined in the label
   * descriptor. If the either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7;</code>
   */
  public boolean containsLabelExtractors(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabelExtractors().getMap().containsKey(key);
  }
  /** Use {@link #getLabelExtractorsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
    return getLabelExtractorsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   * The extracted value is converted to the type defined in the label
   * descriptor. If the either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
    return internalGetLabelExtractors().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   * The extracted value is converted to the type defined in the label
   * descriptor. If the either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7;</code>
   */
  public java.lang.String getLabelExtractorsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   * The extracted value is converted to the type defined in the label
   * descriptor. If the either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7;</code>
   */
  public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BUCKET_OPTIONS_FIELD_NUMBER = 8;
  private com.google.api.Distribution.BucketOptions bucketOptions_;
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
   */
  public boolean hasBucketOptions() {
    return bucketOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
   */
  public com.google.api.Distribution.BucketOptions getBucketOptions() {
    return bucketOptions_ == null
        ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
        : bucketOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
   */
  public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
    return getBucketOptions();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int VERSION_FIELD_NUMBER = 4;
  private int version_;
  /**
   *
   *
   * <pre>
   * Deprecated. The API version that created or updated this metric.
   * The v2 format is used by default and cannot be changed.
   * </pre>
   *
   * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  public int getVersionValue() {
    return version_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The API version that created or updated this metric.
   * The v2 format is used by default and cannot be changed.
   * </pre>
   *
   * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  public com.google.logging.v2.LogMetric.ApiVersion getVersion() {
    @SuppressWarnings("deprecation")
    com.google.logging.v2.LogMetric.ApiVersion result =
        com.google.logging.v2.LogMetric.ApiVersion.valueOf(version_);
    return result == null ? com.google.logging.v2.LogMetric.ApiVersion.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!getFilterBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (version_ != com.google.logging.v2.LogMetric.ApiVersion.V2.getNumber()) {
      output.writeEnum(4, version_);
    }
    if (metricDescriptor_ != null) {
      output.writeMessage(5, getMetricDescriptor());
    }
    if (!getValueExtractorBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, valueExtractor_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabelExtractors(), LabelExtractorsDefaultEntryHolder.defaultEntry, 7);
    if (bucketOptions_ != null) {
      output.writeMessage(8, getBucketOptions());
    }
    if (createTime_ != null) {
      output.writeMessage(9, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(10, getUpdateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!getFilterBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (version_ != com.google.logging.v2.LogMetric.ApiVersion.V2.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, version_);
    }
    if (metricDescriptor_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetricDescriptor());
    }
    if (!getValueExtractorBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, valueExtractor_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabelExtractors().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
          LabelExtractorsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labelExtractors__);
    }
    if (bucketOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getBucketOptions());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.LogMetric)) {
      return super.equals(obj);
    }
    com.google.logging.v2.LogMetric other = (com.google.logging.v2.LogMetric) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasMetricDescriptor() != other.hasMetricDescriptor()) return false;
    if (hasMetricDescriptor()) {
      if (!getMetricDescriptor().equals(other.getMetricDescriptor())) return false;
    }
    if (!getValueExtractor().equals(other.getValueExtractor())) return false;
    if (!internalGetLabelExtractors().equals(other.internalGetLabelExtractors())) return false;
    if (hasBucketOptions() != other.hasBucketOptions()) return false;
    if (hasBucketOptions()) {
      if (!getBucketOptions().equals(other.getBucketOptions())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (version_ != other.version_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasMetricDescriptor()) {
      hash = (37 * hash) + METRIC_DESCRIPTOR_FIELD_NUMBER;
      hash = (53 * hash) + getMetricDescriptor().hashCode();
    }
    hash = (37 * hash) + VALUE_EXTRACTOR_FIELD_NUMBER;
    hash = (53 * hash) + getValueExtractor().hashCode();
    if (!internalGetLabelExtractors().getMap().isEmpty()) {
      hash = (37 * hash) + LABEL_EXTRACTORS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabelExtractors().hashCode();
    }
    if (hasBucketOptions()) {
      hash = (37 * hash) + BUCKET_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketOptions().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + version_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.LogMetric parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.LogMetric prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a logs-based metric. The value of the metric is the number of log
   * entries that match a logs filter in a given time interval.
   * Logs-based metric can also be used to extract values from logs and create a
   * a distribution of the values. The distribution records the statistics of the
   * extracted values along with an optional histogram of the values as specified
   * by the bucket options.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.LogMetric}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.LogMetric)
      com.google.logging.v2.LogMetricOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabelExtractors();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabelExtractors();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.LogMetric.class, com.google.logging.v2.LogMetric.Builder.class);
    }

    // Construct using com.google.logging.v2.LogMetric.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      filter_ = "";

      if (metricDescriptorBuilder_ == null) {
        metricDescriptor_ = null;
      } else {
        metricDescriptor_ = null;
        metricDescriptorBuilder_ = null;
      }
      valueExtractor_ = "";

      internalGetMutableLabelExtractors().clear();
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      version_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric getDefaultInstanceForType() {
      return com.google.logging.v2.LogMetric.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric build() {
      com.google.logging.v2.LogMetric result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric buildPartial() {
      com.google.logging.v2.LogMetric result = new com.google.logging.v2.LogMetric(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      result.description_ = description_;
      result.filter_ = filter_;
      if (metricDescriptorBuilder_ == null) {
        result.metricDescriptor_ = metricDescriptor_;
      } else {
        result.metricDescriptor_ = metricDescriptorBuilder_.build();
      }
      result.valueExtractor_ = valueExtractor_;
      result.labelExtractors_ = internalGetLabelExtractors();
      result.labelExtractors_.makeImmutable();
      if (bucketOptionsBuilder_ == null) {
        result.bucketOptions_ = bucketOptions_;
      } else {
        result.bucketOptions_ = bucketOptionsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.version_ = version_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.LogMetric) {
        return mergeFrom((com.google.logging.v2.LogMetric) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.LogMetric other) {
      if (other == com.google.logging.v2.LogMetric.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (other.hasMetricDescriptor()) {
        mergeMetricDescriptor(other.getMetricDescriptor());
      }
      if (!other.getValueExtractor().isEmpty()) {
        valueExtractor_ = other.valueExtractor_;
        onChanged();
      }
      internalGetMutableLabelExtractors().mergeFrom(other.internalGetLabelExtractors());
      if (other.hasBucketOptions()) {
        mergeBucketOptions(other.getBucketOptions());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.version_ != 0) {
        setVersionValue(other.getVersionValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.logging.v2.LogMetric parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.logging.v2.LogMetric) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]` part of a
     * `metric_name` API parameter, then the metric identifier must be
     * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]` part of a
     * `metric_name` API parameter, then the metric identifier must be
     * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]` part of a
     * `metric_name` API parameter, then the metric identifier must be
     * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]` part of a
     * `metric_name` API parameter, then the metric identifier must be
     * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]` part of a
     * `metric_name` API parameter, then the metric identifier must be
     * URL-encoded. Example: `"projects/my-project/metrics/nginx%2Frequests"`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3;</code>
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3;</code>
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3;</code>
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3;</code>
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3;</code>
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private com.google.api.MetricDescriptor metricDescriptor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        metricDescriptorBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public boolean hasMetricDescriptor() {
      return metricDescriptorBuilder_ != null || metricDescriptor_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public com.google.api.MetricDescriptor getMetricDescriptor() {
      if (metricDescriptorBuilder_ == null) {
        return metricDescriptor_ == null
            ? com.google.api.MetricDescriptor.getDefaultInstance()
            : metricDescriptor_;
      } else {
        return metricDescriptorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public Builder setMetricDescriptor(com.google.api.MetricDescriptor value) {
      if (metricDescriptorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricDescriptor_ = value;
        onChanged();
      } else {
        metricDescriptorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public Builder setMetricDescriptor(com.google.api.MetricDescriptor.Builder builderForValue) {
      if (metricDescriptorBuilder_ == null) {
        metricDescriptor_ = builderForValue.build();
        onChanged();
      } else {
        metricDescriptorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public Builder mergeMetricDescriptor(com.google.api.MetricDescriptor value) {
      if (metricDescriptorBuilder_ == null) {
        if (metricDescriptor_ != null) {
          metricDescriptor_ =
              com.google.api.MetricDescriptor.newBuilder(metricDescriptor_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metricDescriptor_ = value;
        }
        onChanged();
      } else {
        metricDescriptorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public Builder clearMetricDescriptor() {
      if (metricDescriptorBuilder_ == null) {
        metricDescriptor_ = null;
        onChanged();
      } else {
        metricDescriptor_ = null;
        metricDescriptorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public com.google.api.MetricDescriptor.Builder getMetricDescriptorBuilder() {

      onChanged();
      return getMetricDescriptorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    public com.google.api.MetricDescriptorOrBuilder getMetricDescriptorOrBuilder() {
      if (metricDescriptorBuilder_ != null) {
        return metricDescriptorBuilder_.getMessageOrBuilder();
      } else {
        return metricDescriptor_ == null
            ? com.google.api.MetricDescriptor.getDefaultInstance()
            : metricDescriptor_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor metric_descriptor = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        getMetricDescriptorFieldBuilder() {
      if (metricDescriptorBuilder_ == null) {
        metricDescriptorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MetricDescriptor,
                com.google.api.MetricDescriptor.Builder,
                com.google.api.MetricDescriptorOrBuilder>(
                getMetricDescriptor(), getParentForChildren(), isClean());
        metricDescriptor_ = null;
      }
      return metricDescriptorBuilder_;
    }

    private java.lang.Object valueExtractor_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The argument are:
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6;</code>
     */
    public java.lang.String getValueExtractor() {
      java.lang.Object ref = valueExtractor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        valueExtractor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The argument are:
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6;</code>
     */
    public com.google.protobuf.ByteString getValueExtractorBytes() {
      java.lang.Object ref = valueExtractor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        valueExtractor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The argument are:
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6;</code>
     */
    public Builder setValueExtractor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      valueExtractor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The argument are:
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6;</code>
     */
    public Builder clearValueExtractor() {

      valueExtractor_ = getDefaultInstance().getValueExtractor();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The argument are:
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6;</code>
     */
    public Builder setValueExtractorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      valueExtractor_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetLabelExtractors() {
      if (labelExtractors_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LabelExtractorsDefaultEntryHolder.defaultEntry);
      }
      return labelExtractors_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabelExtractors() {
      onChanged();
      ;
      if (labelExtractors_ == null) {
        labelExtractors_ =
            com.google.protobuf.MapField.newMapField(
                LabelExtractorsDefaultEntryHolder.defaultEntry);
      }
      if (!labelExtractors_.isMutable()) {
        labelExtractors_ = labelExtractors_.copy();
      }
      return labelExtractors_;
    }

    public int getLabelExtractorsCount() {
      return internalGetLabelExtractors().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public boolean containsLabelExtractors(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabelExtractors().getMap().containsKey(key);
    }
    /** Use {@link #getLabelExtractorsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
      return getLabelExtractorsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
      return internalGetLabelExtractors().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public java.lang.String getLabelExtractorsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabelExtractors() {
      internalGetMutableLabelExtractors().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public Builder removeLabelExtractors(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabelExtractors().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabelExtractors() {
      return internalGetMutableLabelExtractors().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public Builder putLabelExtractors(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabelExtractors().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     * The extracted value is converted to the type defined in the label
     * descriptor. If the either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>map&lt;string, string&gt; label_extractors = 7;</code>
     */
    public Builder putAllLabelExtractors(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabelExtractors().getMutableMap().putAll(values);
      return this;
    }

    private com.google.api.Distribution.BucketOptions bucketOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.BucketOptions,
            com.google.api.Distribution.BucketOptions.Builder,
            com.google.api.Distribution.BucketOptionsOrBuilder>
        bucketOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public boolean hasBucketOptions() {
      return bucketOptionsBuilder_ != null || bucketOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public com.google.api.Distribution.BucketOptions getBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        return bucketOptions_ == null
            ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      } else {
        return bucketOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public Builder setBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOptions_ = value;
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public Builder setBucketOptions(
        com.google.api.Distribution.BucketOptions.Builder builderForValue) {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = builderForValue.build();
        onChanged();
      } else {
        bucketOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public Builder mergeBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (bucketOptions_ != null) {
          bucketOptions_ =
              com.google.api.Distribution.BucketOptions.newBuilder(bucketOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          bucketOptions_ = value;
        }
        onChanged();
      } else {
        bucketOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public Builder clearBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = null;
        onChanged();
      } else {
        bucketOptions_ = null;
        bucketOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public com.google.api.Distribution.BucketOptions.Builder getBucketOptionsBuilder() {

      onChanged();
      return getBucketOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
      if (bucketOptionsBuilder_ != null) {
        return bucketOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bucketOptions_ == null
            ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>.google.api.Distribution.BucketOptions bucket_options = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.BucketOptions,
            com.google.api.Distribution.BucketOptions.Builder,
            com.google.api.Distribution.BucketOptionsOrBuilder>
        getBucketOptionsFieldBuilder() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Distribution.BucketOptions,
                com.google.api.Distribution.BucketOptions.Builder,
                com.google.api.Distribution.BucketOptionsOrBuilder>(
                getBucketOptions(), getParentForChildren(), isClean());
        bucketOptions_ = null;
      }
      return bucketOptionsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int version_ = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public int getVersionValue() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setVersionValue(int value) {
      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.logging.v2.LogMetric.ApiVersion getVersion() {
      @SuppressWarnings("deprecation")
      com.google.logging.v2.LogMetric.ApiVersion result =
          com.google.logging.v2.LogMetric.ApiVersion.valueOf(version_);
      return result == null ? com.google.logging.v2.LogMetric.ApiVersion.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setVersion(com.google.logging.v2.LogMetric.ApiVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }

      version_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearVersion() {

      version_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.LogMetric)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.LogMetric)
  private static final com.google.logging.v2.LogMetric DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.LogMetric();
  }

  public static com.google.logging.v2.LogMetric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogMetric> PARSER =
      new com.google.protobuf.AbstractParser<LogMetric>() {
        @java.lang.Override
        public LogMetric parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LogMetric(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LogMetric> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogMetric> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.LogMetric getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
