/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.locationfinder.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudLocationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudLocations/{cloud_location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudLocation;

    @Deprecated
    protected CloudLocationName() {
        this.project = null;
        this.location = null;
        this.cloudLocation = null;
    }

    private CloudLocationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudLocation = (String)Preconditions.checkNotNull((Object)builder.getCloudLocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudLocation() {
        return this.cloudLocation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudLocationName of(String project, String location, String cloudLocation) {
        return CloudLocationName.newBuilder().setProject(project).setLocation(location).setCloudLocation(cloudLocation).build();
    }

    public static String format(String project, String location, String cloudLocation) {
        return CloudLocationName.newBuilder().setProject(project).setLocation(location).setCloudLocation(cloudLocation).build().toString();
    }

    public static CloudLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_LOCATION.validatedMatch(formattedString, "CloudLocationName.parse: formattedString not in valid format");
        return CloudLocationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_location"));
    }

    public static List<CloudLocationName> parseList(List<String> formattedStrings) {
        ArrayList<CloudLocationName> list = new ArrayList<CloudLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudLocationName cloudLocationName = this;
            synchronized (cloudLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudLocation != null) {
                        fieldMapBuilder.put((Object)"cloud_location", (Object)this.cloudLocation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_LOCATION.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_location", this.cloudLocation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudLocationName that = (CloudLocationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudLocation, that.cloudLocation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudLocation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudLocation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudLocation() {
            return this.cloudLocation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudLocation(String cloudLocation) {
            this.cloudLocation = cloudLocation;
            return this;
        }

        private Builder(CloudLocationName cloudLocationName) {
            this.project = cloudLocationName.project;
            this.location = cloudLocationName.location;
            this.cloudLocation = cloudLocationName.cloudLocation;
        }

        public CloudLocationName build() {
            return new CloudLocationName(this);
        }
    }
}

