/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClipName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CHANNEL_CLIP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/channels/{channel}/clips/{clip}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String channel;
    private final String clip;

    @Deprecated
    protected ClipName() {
        this.project = null;
        this.location = null;
        this.channel = null;
        this.clip = null;
    }

    private ClipName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.channel = (String)Preconditions.checkNotNull((Object)builder.getChannel());
        this.clip = (String)Preconditions.checkNotNull((Object)builder.getClip());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getClip() {
        return this.clip;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClipName of(String project, String location, String channel, String clip) {
        return ClipName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setClip(clip).build();
    }

    public static String format(String project, String location, String channel, String clip) {
        return ClipName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setClip(clip).build().toString();
    }

    public static ClipName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CHANNEL_CLIP.validatedMatch(formattedString, "ClipName.parse: formattedString not in valid format");
        return ClipName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("channel"), (String)matchMap.get("clip"));
    }

    public static List<ClipName> parseList(List<String> formattedStrings) {
        ArrayList<ClipName> list = new ArrayList<ClipName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClipName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClipName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClipName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CHANNEL_CLIP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClipName clipName = this;
            synchronized (clipName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.channel != null) {
                        fieldMapBuilder.put((Object)"channel", (Object)this.channel);
                    }
                    if (this.clip != null) {
                        fieldMapBuilder.put((Object)"clip", (Object)this.clip);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CHANNEL_CLIP.instantiate(new String[]{"project", this.project, "location", this.location, "channel", this.channel, "clip", this.clip});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ClipName that = (ClipName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.channel, that.channel) && Objects.equals(this.clip, that.clip);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.channel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clip);
    }

    public static class Builder {
        private String project;
        private String location;
        private String channel;
        private String clip;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getClip() {
            return this.clip;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setClip(String clip) {
            this.clip = clip;
            return this;
        }

        private Builder(ClipName clipName) {
            this.project = clipName.project;
            this.location = clipName.location;
            this.channel = clipName.channel;
            this.clip = clipName.clip;
        }

        public ClipName build() {
            return new ClipName(this);
        }
    }
}

