/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/pools/{pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String pool;

    @Deprecated
    protected PoolName() {
        this.project = null;
        this.location = null;
        this.pool = null;
    }

    private PoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.pool = (String)Preconditions.checkNotNull((Object)builder.getPool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPool() {
        return this.pool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PoolName of(String project, String location, String pool) {
        return PoolName.newBuilder().setProject(project).setLocation(location).setPool(pool).build();
    }

    public static String format(String project, String location, String pool) {
        return PoolName.newBuilder().setProject(project).setLocation(location).setPool(pool).build().toString();
    }

    public static PoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_POOL.validatedMatch(formattedString, "PoolName.parse: formattedString not in valid format");
        return PoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("pool"));
    }

    public static List<PoolName> parseList(List<String> formattedStrings) {
        ArrayList<PoolName> list = new ArrayList<PoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PoolName poolName = this;
            synchronized (poolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.pool != null) {
                        fieldMapBuilder.put((Object)"pool", (Object)this.pool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "pool", this.pool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PoolName that = (PoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.pool, that.pool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.pool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String pool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPool() {
            return this.pool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPool(String pool) {
            this.pool = pool;
            return this;
        }

        private Builder(PoolName poolName) {
            this.project = poolName.project;
            this.location = poolName.location;
            this.pool = poolName.pool;
        }

        public PoolName build() {
            return new PoolName(this);
        }
    }
}

