/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CHANNEL_EVENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/channels/{channel}/events/{event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String channel;
    private final String event;

    @Deprecated
    protected EventName() {
        this.project = null;
        this.location = null;
        this.channel = null;
        this.event = null;
    }

    private EventName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.channel = (String)Preconditions.checkNotNull((Object)builder.getChannel());
        this.event = (String)Preconditions.checkNotNull((Object)builder.getEvent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getEvent() {
        return this.event;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EventName of(String project, String location, String channel, String event) {
        return EventName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setEvent(event).build();
    }

    public static String format(String project, String location, String channel, String event) {
        return EventName.newBuilder().setProject(project).setLocation(location).setChannel(channel).setEvent(event).build().toString();
    }

    public static EventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CHANNEL_EVENT.validatedMatch(formattedString, "EventName.parse: formattedString not in valid format");
        return EventName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("channel"), (String)matchMap.get("event"));
    }

    public static List<EventName> parseList(List<String> formattedStrings) {
        ArrayList<EventName> list = new ArrayList<EventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CHANNEL_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventName eventName = this;
            synchronized (eventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.channel != null) {
                        fieldMapBuilder.put((Object)"channel", (Object)this.channel);
                    }
                    if (this.event != null) {
                        fieldMapBuilder.put((Object)"event", (Object)this.event);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CHANNEL_EVENT.instantiate(new String[]{"project", this.project, "location", this.location, "channel", this.channel, "event", this.event});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EventName that = (EventName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.channel, that.channel) && Objects.equals(this.event, that.event);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.channel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.event);
    }

    public static class Builder {
        private String project;
        private String location;
        private String channel;
        private String event;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getEvent() {
            return this.event;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setEvent(String event) {
            this.event = event;
            return this;
        }

        private Builder(EventName eventName) {
            this.project = eventName.project;
            this.location = eventName.location;
            this.channel = eventName.channel;
            this.event = eventName.event;
        }

        public EventName build() {
            return new EventName(this);
        }
    }
}

