/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.licensemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConfigurationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONFIGURATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/configurations/{configuration}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String configuration;

    @Deprecated
    protected ConfigurationName() {
        this.project = null;
        this.location = null;
        this.configuration = null;
    }

    private ConfigurationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.configuration = (String)Preconditions.checkNotNull((Object)builder.getConfiguration());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConfigurationName of(String project, String location, String configuration) {
        return ConfigurationName.newBuilder().setProject(project).setLocation(location).setConfiguration(configuration).build();
    }

    public static String format(String project, String location, String configuration) {
        return ConfigurationName.newBuilder().setProject(project).setLocation(location).setConfiguration(configuration).build().toString();
    }

    public static ConfigurationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONFIGURATION.validatedMatch(formattedString, "ConfigurationName.parse: formattedString not in valid format");
        return ConfigurationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("configuration"));
    }

    public static List<ConfigurationName> parseList(List<String> formattedStrings) {
        ArrayList<ConfigurationName> list = new ArrayList<ConfigurationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConfigurationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConfigurationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConfigurationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONFIGURATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConfigurationName configurationName = this;
            synchronized (configurationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.configuration != null) {
                        fieldMapBuilder.put((Object)"configuration", (Object)this.configuration);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONFIGURATION.instantiate(new String[]{"project", this.project, "location", this.location, "configuration", this.configuration});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConfigurationName that = (ConfigurationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.configuration, that.configuration);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.configuration);
    }

    public static class Builder {
        private String project;
        private String location;
        private String configuration;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConfiguration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        private Builder(ConfigurationName configurationName) {
            this.project = configurationName.project;
            this.location = configurationName.location;
            this.configuration = configurationName.configuration;
        }

        public ConfigurationName build() {
            return new ConfigurationName(this);
        }
    }
}

