/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProtectedResourcesSummaryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEY_RING_CRYPTO_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/protectedResourcesSummary");
    private static final PathTemplate PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}/protectedResourcesSummary");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String keyRing;
    private final String cryptoKey;
    private final String cryptoKeyVersion;

    @Deprecated
    protected ProtectedResourcesSummaryName() {
        this.project = null;
        this.location = null;
        this.keyRing = null;
        this.cryptoKey = null;
        this.cryptoKeyVersion = null;
    }

    private ProtectedResourcesSummaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
        this.cryptoKey = (String)Preconditions.checkNotNull((Object)builder.getCryptoKey());
        this.cryptoKeyVersion = null;
        this.pathTemplate = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY;
    }

    private ProtectedResourcesSummaryName(ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
        this.cryptoKey = (String)Preconditions.checkNotNull((Object)builder.getCryptoKey());
        this.cryptoKeyVersion = (String)Preconditions.checkNotNull((Object)builder.getCryptoKeyVersion());
        this.pathTemplate = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public String getCryptoKey() {
        return this.cryptoKey;
    }

    public String getCryptoKeyVersion() {
        return this.cryptoKeyVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationKeyRingCryptoKeyBuilder() {
        return new Builder();
    }

    public static ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder newProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder() {
        return new ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProtectedResourcesSummaryName of(String project, String location, String keyRing, String cryptoKey) {
        return ProtectedResourcesSummaryName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build();
    }

    public static ProtectedResourcesSummaryName ofProjectLocationKeyRingCryptoKeyName(String project, String location, String keyRing, String cryptoKey) {
        return ProtectedResourcesSummaryName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build();
    }

    public static ProtectedResourcesSummaryName ofProjectLocationKeyRingCryptoKeyCryptoKeyVersionName(String project, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) {
        return ProtectedResourcesSummaryName.newProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).setCryptoKeyVersion(cryptoKeyVersion).build();
    }

    public static String format(String project, String location, String keyRing, String cryptoKey) {
        return ProtectedResourcesSummaryName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build().toString();
    }

    public static String formatProjectLocationKeyRingCryptoKeyName(String project, String location, String keyRing, String cryptoKey) {
        return ProtectedResourcesSummaryName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build().toString();
    }

    public static String formatProjectLocationKeyRingCryptoKeyCryptoKeyVersionName(String project, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) {
        return ProtectedResourcesSummaryName.newProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).setCryptoKeyVersion(cryptoKeyVersion).build().toString();
    }

    public static ProtectedResourcesSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.match(formattedString);
            return ProtectedResourcesSummaryName.ofProjectLocationKeyRingCryptoKeyName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"), (String)matchMap.get("crypto_key"));
        }
        if (PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.match(formattedString);
            return ProtectedResourcesSummaryName.ofProjectLocationKeyRingCryptoKeyCryptoKeyVersionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"), (String)matchMap.get("crypto_key"), (String)matchMap.get("crypto_key_version"));
        }
        throw new ValidationException("ProtectedResourcesSummaryName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ProtectedResourcesSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<ProtectedResourcesSummaryName> list = new ArrayList<ProtectedResourcesSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProtectedResourcesSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProtectedResourcesSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProtectedResourcesSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.matches(formattedString) || PROJECT_LOCATION_KEY_RING_CRYPTO_KEY_CRYPTO_KEY_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProtectedResourcesSummaryName protectedResourcesSummaryName = this;
            synchronized (protectedResourcesSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.keyRing != null) {
                        fieldMapBuilder.put((Object)"key_ring", (Object)this.keyRing);
                    }
                    if (this.cryptoKey != null) {
                        fieldMapBuilder.put((Object)"crypto_key", (Object)this.cryptoKey);
                    }
                    if (this.cryptoKeyVersion != null) {
                        fieldMapBuilder.put((Object)"crypto_key_version", (Object)this.cryptoKeyVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProtectedResourcesSummaryName that = (ProtectedResourcesSummaryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyRing, that.keyRing) && Objects.equals(this.cryptoKey, that.cryptoKey) && Objects.equals(this.cryptoKeyVersion, that.cryptoKeyVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.keyRing);
        h *= 1000003;
        h ^= Objects.hashCode(this.cryptoKey);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cryptoKeyVersion);
    }

    public static class ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder {
        private String project;
        private String location;
        private String keyRing;
        private String cryptoKey;
        private String cryptoKeyVersion;

        protected ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getCryptoKey() {
            return this.cryptoKey;
        }

        public String getCryptoKeyVersion() {
            return this.cryptoKeyVersion;
        }

        public ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder setCryptoKey(String cryptoKey) {
            this.cryptoKey = cryptoKey;
            return this;
        }

        public ProjectLocationKeyRingCryptoKeyCryptoKeyVersionBuilder setCryptoKeyVersion(String cryptoKeyVersion) {
            this.cryptoKeyVersion = cryptoKeyVersion;
            return this;
        }

        public ProtectedResourcesSummaryName build() {
            return new ProtectedResourcesSummaryName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;
        private String cryptoKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getCryptoKey() {
            return this.cryptoKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public Builder setCryptoKey(String cryptoKey) {
            this.cryptoKey = cryptoKey;
            return this;
        }

        private Builder(ProtectedResourcesSummaryName protectedResourcesSummaryName) {
            Preconditions.checkArgument((boolean)Objects.equals(protectedResourcesSummaryName.pathTemplate, PROJECT_LOCATION_KEY_RING_CRYPTO_KEY), (Object)"toBuilder is only supported when ProtectedResourcesSummaryName has the pattern of projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/protectedResourcesSummary");
            this.project = protectedResourcesSummaryName.project;
            this.location = protectedResourcesSummaryName.location;
            this.keyRing = protectedResourcesSummaryName.keyRing;
            this.cryptoKey = protectedResourcesSummaryName.cryptoKey;
        }

        public ProtectedResourcesSummaryName build() {
            return new ProtectedResourcesSummaryName(this);
        }
    }
}

