/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.KmsResourcesProto;
import com.google.cloud.kms.v1.PublicKeyOrBuilder;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class PublicKey
extends GeneratedMessageV3
implements PublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PEM_FIELD_NUMBER = 1;
    private volatile Object pem_;
    public static final int ALGORITHM_FIELD_NUMBER = 2;
    private int algorithm_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final PublicKey DEFAULT_INSTANCE = new PublicKey();
    private static final Parser<PublicKey> PARSER = new AbstractParser<PublicKey>(){

        public PublicKey parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new PublicKey(input, extensionRegistry);
        }
    };

    private PublicKey(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private PublicKey() {
        this.pem_ = "";
        this.algorithm_ = 0;
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private PublicKey(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block11: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block11;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.pem_ = s;
                        continue block11;
                    }
                    case 16: {
                        int rawValue;
                        this.algorithm_ = rawValue = input.readEnum();
                        continue block11;
                    }
                }
                if (this.parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable.ensureFieldAccessorsInitialized(PublicKey.class, Builder.class);
    }

    @Override
    public String getPem() {
        Object ref = this.pem_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.pem_ = s;
        return s;
    }

    @Override
    public ByteString getPemBytes() {
        Object ref = this.pem_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.pem_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAlgorithmValue() {
        return this.algorithm_;
    }

    @Override
    public CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
        CryptoKeyVersion.CryptoKeyVersionAlgorithm result = CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(this.algorithm_);
        return result == null ? CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!this.getPemBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.pem_);
        }
        if (this.algorithm_ != CryptoKeyVersion.CryptoKeyVersionAlgorithm.CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.algorithm_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getPemBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.pem_);
        }
        if (this.algorithm_ != CryptoKeyVersion.CryptoKeyVersionAlgorithm.CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.algorithm_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PublicKey)) {
            return super.equals(obj);
        }
        PublicKey other = (PublicKey)obj;
        boolean result = true;
        result = result && this.getPem().equals(other.getPem());
        result = result && this.algorithm_ == other.algorithm_;
        result = result && this.unknownFields.equals((Object)other.unknownFields);
        return result;
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + PublicKey.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getPem().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.algorithm_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static PublicKey parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (PublicKey)PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(InputStream input) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static PublicKey parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PublicKey parseDelimitedFrom(InputStream input) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static PublicKey parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static PublicKey parseFrom(CodedInputStream input) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static PublicKey parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (PublicKey)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return PublicKey.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PublicKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static PublicKey getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<PublicKey> parser() {
        return PARSER;
    }

    public Parser<PublicKey> getParserForType() {
        return PARSER;
    }

    public PublicKey getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements PublicKeyOrBuilder {
        private Object pem_ = "";
        private int algorithm_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable.ensureFieldAccessorsInitialized(PublicKey.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.pem_ = "";
            this.algorithm_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
        }

        public PublicKey getDefaultInstanceForType() {
            return PublicKey.getDefaultInstance();
        }

        public PublicKey build() {
            PublicKey result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public PublicKey buildPartial() {
            PublicKey result = new PublicKey(this);
            result.pem_ = this.pem_;
            result.algorithm_ = this.algorithm_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof PublicKey) {
                return this.mergeFrom((PublicKey)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(PublicKey other) {
            if (other == PublicKey.getDefaultInstance()) {
                return this;
            }
            if (!other.getPem().isEmpty()) {
                this.pem_ = other.pem_;
                this.onChanged();
            }
            if (other.algorithm_ != 0) {
                this.setAlgorithmValue(other.getAlgorithmValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            PublicKey parsedMessage = null;
            try {
                parsedMessage = (PublicKey)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (PublicKey)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getPem() {
            Object ref = this.pem_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.pem_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPemBytes() {
            Object ref = this.pem_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pem_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPem(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pem_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPem() {
            this.pem_ = PublicKey.getDefaultInstance().getPem();
            this.onChanged();
            return this;
        }

        public Builder setPemBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PublicKey.checkByteStringIsUtf8((ByteString)value);
            this.pem_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getAlgorithmValue() {
            return this.algorithm_;
        }

        public Builder setAlgorithmValue(int value) {
            this.algorithm_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
            CryptoKeyVersion.CryptoKeyVersionAlgorithm result = CryptoKeyVersion.CryptoKeyVersionAlgorithm.valueOf(this.algorithm_);
            return result == null ? CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED : result;
        }

        public Builder setAlgorithm(CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.algorithm_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAlgorithm() {
            this.algorithm_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

