/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

public interface RawEncryptRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.kms.v1.RawEncryptRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * encryption.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * encryption.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The data to encrypt. Must be no larger than 64KiB.
   *
   * The maximum size depends on the key version's
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
   * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the
   * plaintext must be no larger than 64KiB. For
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
   * the plaintext and additional_authenticated_data fields must be no larger
   * than 8KiB.
   * </pre>
   *
   * <code>bytes plaintext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The plaintext.
   */
  com.google.protobuf.ByteString getPlaintext();

  /**
   *
   *
   * <pre>
   * Optional. Optional data that, if specified, must also be provided during
   * decryption through
   * [RawDecryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data].
   *
   * This field may only be used in conjunction with an
   * [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm] that accepts
   * additional authenticated data (for example, AES-GCM).
   *
   * The maximum size depends on the key version's
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level].
   * For [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the
   * plaintext must be no larger than 64KiB. For
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of
   * the plaintext and additional_authenticated_data fields must be no larger
   * than 8KiB.
   * </pre>
   *
   * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The additionalAuthenticatedData.
   */
  com.google.protobuf.ByteString getAdditionalAuthenticatedData();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.plaintext][google.cloud.kms.v1.RawEncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received plaintext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(plaintext) is equal
   * to plaintext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the plaintextCrc32c field is set.
   */
  boolean hasPlaintextCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.plaintext][google.cloud.kms.v1.RawEncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received plaintext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(plaintext) is equal
   * to plaintext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The plaintextCrc32c.
   */
  com.google.protobuf.Int64Value getPlaintextCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.plaintext][google.cloud.kms.v1.RawEncryptRequest.plaintext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received plaintext using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that CRC32C(plaintext) is equal
   * to plaintext_crc32c, and if so, perform a limited number of retries. A
   * persistent mismatch may indicate an issue in your computation of the CRC32C
   * checksum. Note: This field is defined as int64 for reasons of compatibility
   * across different languages. However, it is a non-negative integer, which
   * will never exceed 2^32-1, and can be safely downconverted to uint32 in
   * languages that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value plaintext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the additionalAuthenticatedDataCrc32c field is set.
   */
  boolean hasAdditionalAuthenticatedDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The additionalAuthenticatedDataCrc32c.
   */
  com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.additional_authenticated_data][google.cloud.kms.v1.RawEncryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received additional_authenticated_data using
   * this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(additional_authenticated_data) is equal to
   * additional_authenticated_data_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A customer-supplied initialization vector that will be used for
   * encryption. If it is not provided for AES-CBC and AES-CTR, one will be
   * generated. It will be returned in
   * [RawEncryptResponse.initialization_vector][google.cloud.kms.v1.RawEncryptResponse.initialization_vector].
   * </pre>
   *
   * <code>bytes initialization_vector = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The initializationVector.
   */
  com.google.protobuf.ByteString getInitializationVector();

  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.initialization_vector][google.cloud.kms.v1.RawEncryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to
   * initialization_vector_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the initializationVectorCrc32c field is set.
   */
  boolean hasInitializationVectorCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.initialization_vector][google.cloud.kms.v1.RawEncryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to
   * initialization_vector_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The initializationVectorCrc32c.
   */
  com.google.protobuf.Int64Value getInitializationVectorCrc32C();
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [RawEncryptRequest.initialization_vector][google.cloud.kms.v1.RawEncryptRequest.initialization_vector].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received initialization_vector using this
   * checksum. [KeyManagementService][google.cloud.kms.v1.KeyManagementService]
   * will report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C(initialization_vector) is equal to
   * initialization_vector_crc32c, and if so, perform
   * a limited number of retries. A persistent mismatch may indicate an issue in
   * your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value initialization_vector_crc32c = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.Int64ValueOrBuilder getInitializationVectorCrc32COrBuilder();
}
