/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [KeyManagementService.RawDecrypt][google.cloud.kms.v1.KeyManagementService.RawDecrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.RawDecryptResponse}
 */
public final class RawDecryptResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.RawDecryptResponse)
    RawDecryptResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RawDecryptResponse.newBuilder() to construct.
  private RawDecryptResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RawDecryptResponse() {
    plaintext_ = com.google.protobuf.ByteString.EMPTY;
    protectionLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RawDecryptResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_RawDecryptResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_RawDecryptResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.RawDecryptResponse.class,
            com.google.cloud.kms.v1.RawDecryptResponse.Builder.class);
  }

  public static final int PLAINTEXT_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString plaintext_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The decrypted data.
   * </pre>
   *
   * <code>bytes plaintext = 1;</code>
   *
   * @return The plaintext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaintext() {
    return plaintext_;
  }

  public static final int PLAINTEXT_CRC32C_FIELD_NUMBER = 2;
  private com.google.protobuf.Int64Value plaintextCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return Whether the plaintextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasPlaintextCrc32C() {
    return plaintextCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   *
   * @return The plaintextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getPlaintextCrc32C() {
    return plaintextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : plaintextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
   * An integrity check of plaintext can be performed by computing the CRC32C
   * checksum of plaintext and comparing your results to this field. Discard the
   * response in case of non-matching checksum values, and perform a limited
   * number of retries. A persistent mismatch may indicate an issue in your
   * computation of the CRC32C checksum. Note: receiving this response message
   * indicates that
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
   * successfully decrypt the
   * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
   * that support this type.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
    return plaintextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : plaintextCrc32C_;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 3;
  private int protectionLevel_ = 0;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
   * decryption.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  public static final int VERIFIED_CIPHERTEXT_CRC32C_FIELD_NUMBER = 4;
  private boolean verifiedCiphertextCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of the ciphertext. A false value of this
   * field indicates either that
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_ciphertext_crc32c = 4;</code>
   *
   * @return The verifiedCiphertextCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedCiphertextCrc32C() {
    return verifiedCiphertextCrc32C_;
  }

  public static final int VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER = 5;
  private boolean verifiedAdditionalAuthenticatedDataCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of additional_authenticated_data. A false
   * value of this field indicates either that //
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_additional_authenticated_data_crc32c = 5;</code>
   *
   * @return The verifiedAdditionalAuthenticatedDataCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
    return verifiedAdditionalAuthenticatedDataCrc32C_;
  }

  public static final int VERIFIED_INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER = 6;
  private boolean verifiedInitializationVectorCrc32C_ = false;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A flag indicating whether
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * was received by
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
   * for the integrity verification of initialization_vector. A false value of
   * this field indicates either that
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * was left unset or that it was not delivered to
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
   * set
   * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
   * but this field is still false, discard the response and perform a limited
   * number of retries.
   * </pre>
   *
   * <code>bool verified_initialization_vector_crc32c = 6;</code>
   *
   * @return The verifiedInitializationVectorCrc32c.
   */
  @java.lang.Override
  public boolean getVerifiedInitializationVectorCrc32C() {
    return verifiedInitializationVectorCrc32C_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!plaintext_.isEmpty()) {
      output.writeBytes(1, plaintext_);
    }
    if (plaintextCrc32C_ != null) {
      output.writeMessage(2, getPlaintextCrc32C());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, protectionLevel_);
    }
    if (verifiedCiphertextCrc32C_ != false) {
      output.writeBool(4, verifiedCiphertextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      output.writeBool(5, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (verifiedInitializationVectorCrc32C_ != false) {
      output.writeBool(6, verifiedInitializationVectorCrc32C_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!plaintext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, plaintext_);
    }
    if (plaintextCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPlaintextCrc32C());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, protectionLevel_);
    }
    if (verifiedCiphertextCrc32C_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, verifiedCiphertextCrc32C_);
    }
    if (verifiedAdditionalAuthenticatedDataCrc32C_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              5, verifiedAdditionalAuthenticatedDataCrc32C_);
    }
    if (verifiedInitializationVectorCrc32C_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              6, verifiedInitializationVectorCrc32C_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.RawDecryptResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.RawDecryptResponse other =
        (com.google.cloud.kms.v1.RawDecryptResponse) obj;

    if (!getPlaintext().equals(other.getPlaintext())) return false;
    if (hasPlaintextCrc32C() != other.hasPlaintextCrc32C()) return false;
    if (hasPlaintextCrc32C()) {
      if (!getPlaintextCrc32C().equals(other.getPlaintextCrc32C())) return false;
    }
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (getVerifiedCiphertextCrc32C() != other.getVerifiedCiphertextCrc32C()) return false;
    if (getVerifiedAdditionalAuthenticatedDataCrc32C()
        != other.getVerifiedAdditionalAuthenticatedDataCrc32C()) return false;
    if (getVerifiedInitializationVectorCrc32C() != other.getVerifiedInitializationVectorCrc32C())
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PLAINTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getPlaintext().hashCode();
    if (hasPlaintextCrc32C()) {
      hash = (37 * hash) + PLAINTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getPlaintextCrc32C().hashCode();
    }
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (37 * hash) + VERIFIED_CIPHERTEXT_CRC32C_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getVerifiedCiphertextCrc32C());
    hash = (37 * hash) + VERIFIED_ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(
                getVerifiedAdditionalAuthenticatedDataCrc32C());
    hash = (37 * hash) + VERIFIED_INITIALIZATION_VECTOR_CRC32C_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getVerifiedInitializationVectorCrc32C());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.RawDecryptResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [KeyManagementService.RawDecrypt][google.cloud.kms.v1.KeyManagementService.RawDecrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.RawDecryptResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.RawDecryptResponse)
      com.google.cloud.kms.v1.RawDecryptResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawDecryptResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawDecryptResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.RawDecryptResponse.class,
              com.google.cloud.kms.v1.RawDecryptResponse.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.RawDecryptResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      plaintext_ = com.google.protobuf.ByteString.EMPTY;
      plaintextCrc32C_ = null;
      if (plaintextCrc32CBuilder_ != null) {
        plaintextCrc32CBuilder_.dispose();
        plaintextCrc32CBuilder_ = null;
      }
      protectionLevel_ = 0;
      verifiedCiphertextCrc32C_ = false;
      verifiedAdditionalAuthenticatedDataCrc32C_ = false;
      verifiedInitializationVectorCrc32C_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_RawDecryptResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawDecryptResponse getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.RawDecryptResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawDecryptResponse build() {
      com.google.cloud.kms.v1.RawDecryptResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.RawDecryptResponse buildPartial() {
      com.google.cloud.kms.v1.RawDecryptResponse result =
          new com.google.cloud.kms.v1.RawDecryptResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.RawDecryptResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.plaintext_ = plaintext_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.plaintextCrc32C_ =
            plaintextCrc32CBuilder_ == null ? plaintextCrc32C_ : plaintextCrc32CBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.protectionLevel_ = protectionLevel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.verifiedCiphertextCrc32C_ = verifiedCiphertextCrc32C_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.verifiedAdditionalAuthenticatedDataCrc32C_ =
            verifiedAdditionalAuthenticatedDataCrc32C_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.verifiedInitializationVectorCrc32C_ = verifiedInitializationVectorCrc32C_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.RawDecryptResponse) {
        return mergeFrom((com.google.cloud.kms.v1.RawDecryptResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.RawDecryptResponse other) {
      if (other == com.google.cloud.kms.v1.RawDecryptResponse.getDefaultInstance()) return this;
      if (other.getPlaintext() != com.google.protobuf.ByteString.EMPTY) {
        setPlaintext(other.getPlaintext());
      }
      if (other.hasPlaintextCrc32C()) {
        mergePlaintextCrc32C(other.getPlaintextCrc32C());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      if (other.getVerifiedCiphertextCrc32C() != false) {
        setVerifiedCiphertextCrc32C(other.getVerifiedCiphertextCrc32C());
      }
      if (other.getVerifiedAdditionalAuthenticatedDataCrc32C() != false) {
        setVerifiedAdditionalAuthenticatedDataCrc32C(
            other.getVerifiedAdditionalAuthenticatedDataCrc32C());
      }
      if (other.getVerifiedInitializationVectorCrc32C() != false) {
        setVerifiedInitializationVectorCrc32C(other.getVerifiedInitializationVectorCrc32C());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                plaintext_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPlaintextCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                protectionLevel_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                verifiedCiphertextCrc32C_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                verifiedAdditionalAuthenticatedDataCrc32C_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                verifiedInitializationVectorCrc32C_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString plaintext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The decrypted data.
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @return The plaintext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPlaintext() {
      return plaintext_;
    }
    /**
     *
     *
     * <pre>
     * The decrypted data.
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @param value The plaintext to set.
     * @return This builder for chaining.
     */
    public Builder setPlaintext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      plaintext_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The decrypted data.
     * </pre>
     *
     * <code>bytes plaintext = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaintext() {
      bitField0_ = (bitField0_ & ~0x00000001);
      plaintext_ = getDefaultInstance().getPlaintext();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value plaintextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        plaintextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     *
     * @return Whether the plaintextCrc32c field is set.
     */
    public boolean hasPlaintextCrc32C() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     *
     * @return The plaintextCrc32c.
     */
    public com.google.protobuf.Int64Value getPlaintextCrc32C() {
      if (plaintextCrc32CBuilder_ == null) {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      } else {
        return plaintextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        plaintextCrc32C_ = value;
      } else {
        plaintextCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder setPlaintextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32C_ = builderForValue.build();
      } else {
        plaintextCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder mergePlaintextCrc32C(com.google.protobuf.Int64Value value) {
      if (plaintextCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && plaintextCrc32C_ != null
            && plaintextCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getPlaintextCrc32CBuilder().mergeFrom(value);
        } else {
          plaintextCrc32C_ = value;
        }
      } else {
        plaintextCrc32CBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public Builder clearPlaintextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000002);
      plaintextCrc32C_ = null;
      if (plaintextCrc32CBuilder_ != null) {
        plaintextCrc32CBuilder_.dispose();
        plaintextCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64Value.Builder getPlaintextCrc32CBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPlaintextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getPlaintextCrc32COrBuilder() {
      if (plaintextCrc32CBuilder_ != null) {
        return plaintextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return plaintextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : plaintextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [RawDecryptResponse.plaintext][google.cloud.kms.v1.RawDecryptResponse.plaintext].
     * An integrity check of plaintext can be performed by computing the CRC32C
     * checksum of plaintext and comparing your results to this field. Discard the
     * response in case of non-matching checksum values, and perform a limited
     * number of retries. A persistent mismatch may indicate an issue in your
     * computation of the CRC32C checksum. Note: receiving this response message
     * indicates that
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] is able to
     * successfully decrypt the
     * [ciphertext][google.cloud.kms.v1.RawDecryptRequest.ciphertext].
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed 2^32-1, and can be safely downconverted to uint32 in languages
     * that support this type.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value plaintext_crc32c = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getPlaintextCrc32CFieldBuilder() {
      if (plaintextCrc32CBuilder_ == null) {
        plaintextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getPlaintextCrc32C(), getParentForChildren(), isClean());
        plaintextCrc32C_ = null;
      }
      return plaintextCrc32CBuilder_;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {
      protectionLevel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in
     * decryption.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    private boolean verifiedCiphertextCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the ciphertext. A false value of this
     * field indicates either that
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_ciphertext_crc32c = 4;</code>
     *
     * @return The verifiedCiphertextCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedCiphertextCrc32C() {
      return verifiedCiphertextCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the ciphertext. A false value of this
     * field indicates either that
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_ciphertext_crc32c = 4;</code>
     *
     * @param value The verifiedCiphertextCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedCiphertextCrc32C(boolean value) {

      verifiedCiphertextCrc32C_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of the ciphertext. A false value of this
     * field indicates either that
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.RawDecryptRequest.ciphertext_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_ciphertext_crc32c = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedCiphertextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000008);
      verifiedCiphertextCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedAdditionalAuthenticatedDataCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 5;</code>
     *
     * @return The verifiedAdditionalAuthenticatedDataCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedAdditionalAuthenticatedDataCrc32C() {
      return verifiedAdditionalAuthenticatedDataCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 5;</code>
     *
     * @param value The verifiedAdditionalAuthenticatedDataCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedAdditionalAuthenticatedDataCrc32C(boolean value) {

      verifiedAdditionalAuthenticatedDataCrc32C_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of additional_authenticated_data. A false
     * value of this field indicates either that //
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.RawDecryptRequest.additional_authenticated_data_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_additional_authenticated_data_crc32c = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedAdditionalAuthenticatedDataCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000010);
      verifiedAdditionalAuthenticatedDataCrc32C_ = false;
      onChanged();
      return this;
    }

    private boolean verifiedInitializationVectorCrc32C_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 6;</code>
     *
     * @return The verifiedInitializationVectorCrc32c.
     */
    @java.lang.Override
    public boolean getVerifiedInitializationVectorCrc32C() {
      return verifiedInitializationVectorCrc32C_;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 6;</code>
     *
     * @param value The verifiedInitializationVectorCrc32c to set.
     * @return This builder for chaining.
     */
    public Builder setVerifiedInitializationVectorCrc32C(boolean value) {

      verifiedInitializationVectorCrc32C_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A flag indicating whether
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was received by
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] and used
     * for the integrity verification of initialization_vector. A false value of
     * this field indicates either that
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * was left unset or that it was not delivered to
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService]. If you've
     * set
     * [RawDecryptRequest.initialization_vector_crc32c][google.cloud.kms.v1.RawDecryptRequest.initialization_vector_crc32c]
     * but this field is still false, discard the response and perform a limited
     * number of retries.
     * </pre>
     *
     * <code>bool verified_initialization_vector_crc32c = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVerifiedInitializationVectorCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000020);
      verifiedInitializationVectorCrc32C_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.RawDecryptResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.RawDecryptResponse)
  private static final com.google.cloud.kms.v1.RawDecryptResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.RawDecryptResponse();
  }

  public static com.google.cloud.kms.v1.RawDecryptResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RawDecryptResponse> PARSER =
      new com.google.protobuf.AbstractParser<RawDecryptResponse>() {
        @java.lang.Override
        public RawDecryptResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RawDecryptResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RawDecryptResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.RawDecryptResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
