/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an
 * individual cryptographic key, and the associated key material.
 *
 * An
 * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
 * version can be used for cryptographic operations.
 *
 * For security reasons, the raw cryptographic key material represented by a
 * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed
 * or exported. It can only be used to encrypt, decrypt, or sign data when an
 * authorized user or application invokes Cloud KMS.
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
 */
public final class CryptoKeyVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.CryptoKeyVersion)
    CryptoKeyVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoKeyVersion.newBuilder() to construct.
  private CryptoKeyVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoKeyVersion() {
    name_ = "";
    state_ = 0;
    protectionLevel_ = 0;
    algorithm_ = 0;
    importJob_ = "";
    importFailureReason_ = "";
    generationFailureReason_ = "";
    externalDestructionFailureReason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoKeyVersion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.CryptoKeyVersion.class,
            com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The algorithm of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating what
   * parameters must be used for each cryptographic operation.
   *
   * The
   * [GOOGLE_SYMMETRIC_ENCRYPTION][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.GOOGLE_SYMMETRIC_ENCRYPTION]
   * algorithm is usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
   *
   * Algorithms beginning with `RSA_SIGN_` are usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
   *
   * The fields in the name after `RSA_SIGN_` correspond to the following
   * parameters: padding algorithm, modulus bit length, and digest algorithm.
   *
   * For PSS, the salt length used is equal to the length of digest
   * algorithm. For example,
   * [RSA_SIGN_PSS_2048_SHA256][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256]
   * will use PSS with a salt length of 256 bits or 32 bytes.
   *
   * Algorithms beginning with `RSA_DECRYPT_` are usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
   *
   * The fields in the name after `RSA_DECRYPT_` correspond to the following
   * parameters: padding algorithm, modulus bit length, and digest algorithm.
   *
   * Algorithms beginning with `EC_SIGN_` are usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
   *
   * The fields in the name after `EC_SIGN_` correspond to the following
   * parameters: elliptic curve, digest algorithm.
   *
   * Algorithms beginning with `HMAC_` are usable with
   * [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
   * [MAC][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.MAC].
   *
   * The suffix following `HMAC_` corresponds to the hash algorithm being used
   * (eg. SHA256).
   *
   * For more information, see [Key purposes and algorithms]
   * (https://cloud.google.com/kms/docs/algorithms).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm}
   */
  public enum CryptoKeyVersionAlgorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Creates symmetric encryption keys.
     * </pre>
     *
     * <code>GOOGLE_SYMMETRIC_ENCRYPTION = 1;</code>
     */
    GOOGLE_SYMMETRIC_ENCRYPTION(1),
    /**
     *
     *
     * <pre>
     * AES-GCM (Galois Counter Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_GCM = 41;</code>
     */
    AES_128_GCM(41),
    /**
     *
     *
     * <pre>
     * AES-GCM (Galois Counter Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_GCM = 19;</code>
     */
    AES_256_GCM(19),
    /**
     *
     *
     * <pre>
     * AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_CBC = 42;</code>
     */
    AES_128_CBC(42),
    /**
     *
     *
     * <pre>
     * AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_CBC = 43;</code>
     */
    AES_256_CBC(43),
    /**
     *
     *
     * <pre>
     * AES-CTR (Counter Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_CTR = 44;</code>
     */
    AES_128_CTR(44),
    /**
     *
     *
     * <pre>
     * AES-CTR (Counter Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_CTR = 45;</code>
     */
    AES_256_CTR(45),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_2048_SHA256 = 2;</code>
     */
    RSA_SIGN_PSS_2048_SHA256(2),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_3072_SHA256 = 3;</code>
     */
    RSA_SIGN_PSS_3072_SHA256(3),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA256 = 4;</code>
     */
    RSA_SIGN_PSS_4096_SHA256(4),
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA512 = 15;</code>
     */
    RSA_SIGN_PSS_4096_SHA512(15),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    RSA_SIGN_PKCS1_2048_SHA256(5),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    RSA_SIGN_PKCS1_3072_SHA256(6),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA256(7),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 16;</code>
     */
    RSA_SIGN_PKCS1_4096_SHA512(16),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 2048 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_2048 = 28;</code>
     */
    RSA_SIGN_RAW_PKCS1_2048(28),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 3072 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_3072 = 29;</code>
     */
    RSA_SIGN_RAW_PKCS1_3072(29),
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 4096 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_4096 = 30;</code>
     */
    RSA_SIGN_RAW_PKCS1_4096(30),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA256 = 8;</code>
     */
    RSA_DECRYPT_OAEP_2048_SHA256(8),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA256 = 9;</code>
     */
    RSA_DECRYPT_OAEP_3072_SHA256(9),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA256 = 10;</code>
     */
    RSA_DECRYPT_OAEP_4096_SHA256(10),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA512 = 17;</code>
     */
    RSA_DECRYPT_OAEP_4096_SHA512(17),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA1 = 37;</code>
     */
    RSA_DECRYPT_OAEP_2048_SHA1(37),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA1 = 38;</code>
     */
    RSA_DECRYPT_OAEP_3072_SHA1(38),
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA1 = 39;</code>
     */
    RSA_DECRYPT_OAEP_4096_SHA1(39),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 12;</code>
     */
    EC_SIGN_P256_SHA256(12),
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 13;</code>
     */
    EC_SIGN_P384_SHA384(13),
    /**
     *
     *
     * <pre>
     * ECDSA on the non-NIST secp256k1 curve. This curve is only supported for
     * HSM protection level.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_SECP256K1_SHA256 = 31;</code>
     */
    EC_SIGN_SECP256K1_SHA256(31),
    /**
     *
     *
     * <pre>
     * HMAC-SHA256 signing with a 256 bit key.
     * </pre>
     *
     * <code>HMAC_SHA256 = 32;</code>
     */
    HMAC_SHA256(32),
    /**
     *
     *
     * <pre>
     * HMAC-SHA1 signing with a 160 bit key.
     * </pre>
     *
     * <code>HMAC_SHA1 = 33;</code>
     */
    HMAC_SHA1(33),
    /**
     *
     *
     * <pre>
     * HMAC-SHA384 signing with a 384 bit key.
     * </pre>
     *
     * <code>HMAC_SHA384 = 34;</code>
     */
    HMAC_SHA384(34),
    /**
     *
     *
     * <pre>
     * HMAC-SHA512 signing with a 512 bit key.
     * </pre>
     *
     * <code>HMAC_SHA512 = 35;</code>
     */
    HMAC_SHA512(35),
    /**
     *
     *
     * <pre>
     * HMAC-SHA224 signing with a 224 bit key.
     * </pre>
     *
     * <code>HMAC_SHA224 = 36;</code>
     */
    HMAC_SHA224(36),
    /**
     *
     *
     * <pre>
     * Algorithm representing symmetric encryption by an external key manager.
     * </pre>
     *
     * <code>EXTERNAL_SYMMETRIC_ENCRYPTION = 18;</code>
     */
    EXTERNAL_SYMMETRIC_ENCRYPTION(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Creates symmetric encryption keys.
     * </pre>
     *
     * <code>GOOGLE_SYMMETRIC_ENCRYPTION = 1;</code>
     */
    public static final int GOOGLE_SYMMETRIC_ENCRYPTION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * AES-GCM (Galois Counter Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_GCM = 41;</code>
     */
    public static final int AES_128_GCM_VALUE = 41;
    /**
     *
     *
     * <pre>
     * AES-GCM (Galois Counter Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_GCM = 19;</code>
     */
    public static final int AES_256_GCM_VALUE = 19;
    /**
     *
     *
     * <pre>
     * AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_CBC = 42;</code>
     */
    public static final int AES_128_CBC_VALUE = 42;
    /**
     *
     *
     * <pre>
     * AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_CBC = 43;</code>
     */
    public static final int AES_256_CBC_VALUE = 43;
    /**
     *
     *
     * <pre>
     * AES-CTR (Counter Mode) using 128-bit keys.
     * </pre>
     *
     * <code>AES_128_CTR = 44;</code>
     */
    public static final int AES_128_CTR_VALUE = 44;
    /**
     *
     *
     * <pre>
     * AES-CTR (Counter Mode) using 256-bit keys.
     * </pre>
     *
     * <code>AES_256_CTR = 45;</code>
     */
    public static final int AES_256_CTR_VALUE = 45;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_2048_SHA256 = 2;</code>
     */
    public static final int RSA_SIGN_PSS_2048_SHA256_VALUE = 2;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_3072_SHA256 = 3;</code>
     */
    public static final int RSA_SIGN_PSS_3072_SHA256_VALUE = 3;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA256 = 4;</code>
     */
    public static final int RSA_SIGN_PSS_4096_SHA256_VALUE = 4;
    /**
     *
     *
     * <pre>
     * RSASSA-PSS 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PSS_4096_SHA512 = 15;</code>
     */
    public static final int RSA_SIGN_PSS_4096_SHA512_VALUE = 15;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_2048_SHA256 = 5;</code>
     */
    public static final int RSA_SIGN_PKCS1_2048_SHA256_VALUE = 5;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_3072_SHA256 = 6;</code>
     */
    public static final int RSA_SIGN_PKCS1_3072_SHA256_VALUE = 6;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA256 = 7;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA256_VALUE = 7;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA512 digest.
     * </pre>
     *
     * <code>RSA_SIGN_PKCS1_4096_SHA512 = 16;</code>
     */
    public static final int RSA_SIGN_PKCS1_4096_SHA512_VALUE = 16;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 2048 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_2048 = 28;</code>
     */
    public static final int RSA_SIGN_RAW_PKCS1_2048_VALUE = 28;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 3072 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_3072 = 29;</code>
     */
    public static final int RSA_SIGN_RAW_PKCS1_3072_VALUE = 29;
    /**
     *
     *
     * <pre>
     * RSASSA-PKCS1-v1_5 signing without encoding, with a 4096 bit key.
     * </pre>
     *
     * <code>RSA_SIGN_RAW_PKCS1_4096 = 30;</code>
     */
    public static final int RSA_SIGN_RAW_PKCS1_4096_VALUE = 30;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA256 = 8;</code>
     */
    public static final int RSA_DECRYPT_OAEP_2048_SHA256_VALUE = 8;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA256 = 9;</code>
     */
    public static final int RSA_DECRYPT_OAEP_3072_SHA256_VALUE = 9;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA256 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA256 = 10;</code>
     */
    public static final int RSA_DECRYPT_OAEP_4096_SHA256_VALUE = 10;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA512 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA512 = 17;</code>
     */
    public static final int RSA_DECRYPT_OAEP_4096_SHA512_VALUE = 17;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 2048 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_2048_SHA1 = 37;</code>
     */
    public static final int RSA_DECRYPT_OAEP_2048_SHA1_VALUE = 37;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 3072 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_3072_SHA1 = 38;</code>
     */
    public static final int RSA_DECRYPT_OAEP_3072_SHA1_VALUE = 38;
    /**
     *
     *
     * <pre>
     * RSAES-OAEP 4096 bit key with a SHA1 digest.
     * </pre>
     *
     * <code>RSA_DECRYPT_OAEP_4096_SHA1 = 39;</code>
     */
    public static final int RSA_DECRYPT_OAEP_4096_SHA1_VALUE = 39;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-256 curve with a SHA256 digest.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_P256_SHA256 = 12;</code>
     */
    public static final int EC_SIGN_P256_SHA256_VALUE = 12;
    /**
     *
     *
     * <pre>
     * ECDSA on the NIST P-384 curve with a SHA384 digest.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_P384_SHA384 = 13;</code>
     */
    public static final int EC_SIGN_P384_SHA384_VALUE = 13;
    /**
     *
     *
     * <pre>
     * ECDSA on the non-NIST secp256k1 curve. This curve is only supported for
     * HSM protection level.
     * Other hash functions can also be used:
     * https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
     * </pre>
     *
     * <code>EC_SIGN_SECP256K1_SHA256 = 31;</code>
     */
    public static final int EC_SIGN_SECP256K1_SHA256_VALUE = 31;
    /**
     *
     *
     * <pre>
     * HMAC-SHA256 signing with a 256 bit key.
     * </pre>
     *
     * <code>HMAC_SHA256 = 32;</code>
     */
    public static final int HMAC_SHA256_VALUE = 32;
    /**
     *
     *
     * <pre>
     * HMAC-SHA1 signing with a 160 bit key.
     * </pre>
     *
     * <code>HMAC_SHA1 = 33;</code>
     */
    public static final int HMAC_SHA1_VALUE = 33;
    /**
     *
     *
     * <pre>
     * HMAC-SHA384 signing with a 384 bit key.
     * </pre>
     *
     * <code>HMAC_SHA384 = 34;</code>
     */
    public static final int HMAC_SHA384_VALUE = 34;
    /**
     *
     *
     * <pre>
     * HMAC-SHA512 signing with a 512 bit key.
     * </pre>
     *
     * <code>HMAC_SHA512 = 35;</code>
     */
    public static final int HMAC_SHA512_VALUE = 35;
    /**
     *
     *
     * <pre>
     * HMAC-SHA224 signing with a 224 bit key.
     * </pre>
     *
     * <code>HMAC_SHA224 = 36;</code>
     */
    public static final int HMAC_SHA224_VALUE = 36;
    /**
     *
     *
     * <pre>
     * Algorithm representing symmetric encryption by an external key manager.
     * </pre>
     *
     * <code>EXTERNAL_SYMMETRIC_ENCRYPTION = 18;</code>
     */
    public static final int EXTERNAL_SYMMETRIC_ENCRYPTION_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionAlgorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionAlgorithm forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED;
        case 1:
          return GOOGLE_SYMMETRIC_ENCRYPTION;
        case 41:
          return AES_128_GCM;
        case 19:
          return AES_256_GCM;
        case 42:
          return AES_128_CBC;
        case 43:
          return AES_256_CBC;
        case 44:
          return AES_128_CTR;
        case 45:
          return AES_256_CTR;
        case 2:
          return RSA_SIGN_PSS_2048_SHA256;
        case 3:
          return RSA_SIGN_PSS_3072_SHA256;
        case 4:
          return RSA_SIGN_PSS_4096_SHA256;
        case 15:
          return RSA_SIGN_PSS_4096_SHA512;
        case 5:
          return RSA_SIGN_PKCS1_2048_SHA256;
        case 6:
          return RSA_SIGN_PKCS1_3072_SHA256;
        case 7:
          return RSA_SIGN_PKCS1_4096_SHA256;
        case 16:
          return RSA_SIGN_PKCS1_4096_SHA512;
        case 28:
          return RSA_SIGN_RAW_PKCS1_2048;
        case 29:
          return RSA_SIGN_RAW_PKCS1_3072;
        case 30:
          return RSA_SIGN_RAW_PKCS1_4096;
        case 8:
          return RSA_DECRYPT_OAEP_2048_SHA256;
        case 9:
          return RSA_DECRYPT_OAEP_3072_SHA256;
        case 10:
          return RSA_DECRYPT_OAEP_4096_SHA256;
        case 17:
          return RSA_DECRYPT_OAEP_4096_SHA512;
        case 37:
          return RSA_DECRYPT_OAEP_2048_SHA1;
        case 38:
          return RSA_DECRYPT_OAEP_3072_SHA1;
        case 39:
          return RSA_DECRYPT_OAEP_4096_SHA1;
        case 12:
          return EC_SIGN_P256_SHA256;
        case 13:
          return EC_SIGN_P384_SHA384;
        case 31:
          return EC_SIGN_SECP256K1_SHA256;
        case 32:
          return HMAC_SHA256;
        case 33:
          return HMAC_SHA1;
        case 34:
          return HMAC_SHA384;
        case 35:
          return HMAC_SHA512;
        case 36:
          return HMAC_SHA224;
        case 18:
          return EXTERNAL_SYMMETRIC_ENCRYPTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionAlgorithm>() {
              public CryptoKeyVersionAlgorithm findValueByNumber(int number) {
                return CryptoKeyVersionAlgorithm.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(0);
    }

    private static final CryptoKeyVersionAlgorithm[] VALUES = values();

    public static CryptoKeyVersionAlgorithm valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionAlgorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm)
  }

  /**
   *
   *
   * <pre>
   * The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion],
   * indicating if it can be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState}
   */
  public enum CryptoKeyVersionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This version is still being generated. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_GENERATION = 5;</code>
     */
    PENDING_GENERATION(5),
    /**
     *
     *
     * <pre>
     * This version may be used for cryptographic operations.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    /**
     *
     *
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * This version may only become
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * again if this version is
     * [reimport_eligible][google.cloud.kms.v1.CryptoKeyVersion.reimport_eligible]
     * and the original key material is reimported with a call to
     * [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    DESTROYED(3),
    /**
     *
     *
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the
     * [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
     * state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    DESTROY_SCHEDULED(4),
    /**
     *
     *
     * <pre>
     * This version is still being imported. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_IMPORT = 6;</code>
     */
    PENDING_IMPORT(6),
    /**
     *
     *
     * <pre>
     * This version was not imported successfully. It may not be used, enabled,
     * disabled, or destroyed. The submitted key material has been discarded.
     * Additional details can be found in
     * [CryptoKeyVersion.import_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.import_failure_reason].
     * </pre>
     *
     * <code>IMPORT_FAILED = 7;</code>
     */
    IMPORT_FAILED(7),
    /**
     *
     *
     * <pre>
     * This version was not generated successfully. It may not be used, enabled,
     * disabled, or destroyed. Additional details can be found in
     * [CryptoKeyVersion.generation_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.generation_failure_reason].
     * </pre>
     *
     * <code>GENERATION_FAILED = 8;</code>
     */
    GENERATION_FAILED(8),
    /**
     *
     *
     * <pre>
     * This version was destroyed, and it may not be used or enabled again.
     * Cloud KMS is waiting for the corresponding key material residing in an
     * external key manager to be destroyed.
     * </pre>
     *
     * <code>PENDING_EXTERNAL_DESTRUCTION = 9;</code>
     */
    PENDING_EXTERNAL_DESTRUCTION(9),
    /**
     *
     *
     * <pre>
     * This version was destroyed, and it may not be used or enabled again.
     * However, Cloud KMS could not confirm that the corresponding key material
     * residing in an external key manager was destroyed. Additional details can
     * be found in
     * [CryptoKeyVersion.external_destruction_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.external_destruction_failure_reason].
     * </pre>
     *
     * <code>EXTERNAL_DESTRUCTION_FAILED = 10;</code>
     */
    EXTERNAL_DESTRUCTION_FAILED(10),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This version is still being generated. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_GENERATION = 5;</code>
     */
    public static final int PENDING_GENERATION_VALUE = 5;
    /**
     *
     *
     * <pre>
     * This version may be used for cryptographic operations.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This version may not be used, but the key material is still available,
     * and the version can be placed back into the
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * state.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This version is destroyed, and the key material is no longer stored.
     * This version may only become
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * again if this version is
     * [reimport_eligible][google.cloud.kms.v1.CryptoKeyVersion.reimport_eligible]
     * and the original key material is reimported with a call to
     * [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
     * </pre>
     *
     * <code>DESTROYED = 3;</code>
     */
    public static final int DESTROYED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * This version is scheduled for destruction, and will be destroyed soon.
     * Call
     * [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
     * to put it back into the
     * [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
     * state.
     * </pre>
     *
     * <code>DESTROY_SCHEDULED = 4;</code>
     */
    public static final int DESTROY_SCHEDULED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * This version is still being imported. It may not be used, enabled,
     * disabled, or destroyed yet. Cloud KMS will automatically mark this
     * version
     * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
     * as soon as the version is ready.
     * </pre>
     *
     * <code>PENDING_IMPORT = 6;</code>
     */
    public static final int PENDING_IMPORT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * This version was not imported successfully. It may not be used, enabled,
     * disabled, or destroyed. The submitted key material has been discarded.
     * Additional details can be found in
     * [CryptoKeyVersion.import_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.import_failure_reason].
     * </pre>
     *
     * <code>IMPORT_FAILED = 7;</code>
     */
    public static final int IMPORT_FAILED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * This version was not generated successfully. It may not be used, enabled,
     * disabled, or destroyed. Additional details can be found in
     * [CryptoKeyVersion.generation_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.generation_failure_reason].
     * </pre>
     *
     * <code>GENERATION_FAILED = 8;</code>
     */
    public static final int GENERATION_FAILED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * This version was destroyed, and it may not be used or enabled again.
     * Cloud KMS is waiting for the corresponding key material residing in an
     * external key manager to be destroyed.
     * </pre>
     *
     * <code>PENDING_EXTERNAL_DESTRUCTION = 9;</code>
     */
    public static final int PENDING_EXTERNAL_DESTRUCTION_VALUE = 9;
    /**
     *
     *
     * <pre>
     * This version was destroyed, and it may not be used or enabled again.
     * However, Cloud KMS could not confirm that the corresponding key material
     * residing in an external key manager was destroyed. Additional details can
     * be found in
     * [CryptoKeyVersion.external_destruction_failure_reason][google.cloud.kms.v1.CryptoKeyVersion.external_destruction_failure_reason].
     * </pre>
     *
     * <code>EXTERNAL_DESTRUCTION_FAILED = 10;</code>
     */
    public static final int EXTERNAL_DESTRUCTION_FAILED_VALUE = 10;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionState forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_STATE_UNSPECIFIED;
        case 5:
          return PENDING_GENERATION;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        case 3:
          return DESTROYED;
        case 4:
          return DESTROY_SCHEDULED;
        case 6:
          return PENDING_IMPORT;
        case 7:
          return IMPORT_FAILED;
        case 8:
          return GENERATION_FAILED;
        case 9:
          return PENDING_EXTERNAL_DESTRUCTION;
        case 10:
          return EXTERNAL_DESTRUCTION_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionState>() {
              public CryptoKeyVersionState findValueByNumber(int number) {
                return CryptoKeyVersionState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(1);
    }

    private static final CryptoKeyVersionState[] VALUES = values();

    public static CryptoKeyVersionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState)
  }

  /**
   *
   *
   * <pre>
   * A view for [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]s.
   * Controls the level of detail returned for
   * [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] in
   * [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions]
   * and
   * [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionView}
   */
  public enum CryptoKeyVersionView implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default view for each
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not
     * include the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0;</code>
     */
    CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Provides all fields in each
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    FULL(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default view for each
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not
     * include the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
     * </pre>
     *
     * <code>CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Provides all fields in each
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
     * [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
     * </pre>
     *
     * <code>FULL = 1;</code>
     */
    public static final int FULL_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CryptoKeyVersionView valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CryptoKeyVersionView forNumber(int value) {
      switch (value) {
        case 0:
          return CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED;
        case 1:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CryptoKeyVersionView>() {
              public CryptoKeyVersionView findValueByNumber(int number) {
                return CryptoKeyVersionView.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDescriptor().getEnumTypes().get(2);
    }

    private static final CryptoKeyVersionView[] VALUES = values();

    public static CryptoKeyVersionView valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CryptoKeyVersionView(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionView)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name for this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
   * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The current state of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The current state of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.forNumber(state_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED
        : result;
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 7;
  private int protectionLevel_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
   * describing how crypto operations are performed with this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
   * describing how crypto operations are performed with this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  public static final int ALGORITHM_FIELD_NUMBER = 10;
  private int algorithm_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The
   * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
   * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
   * supports.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  @java.lang.Override
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The
   * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
   * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
   * supports.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(algorithm_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
        : result;
  }

  public static final int ATTESTATION_FIELD_NUMBER = 8;
  private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the attestation field is set.
   */
  @java.lang.Override
  public boolean hasAttestation() {
    return attestation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The attestation.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
    return attestation_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
        : attestation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statement that was generated and signed by the HSM at key
   * creation time. Use this statement to verify attributes of the key as stored
   * on the HSM, independently of Google. Only provided for key versions with
   * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
   * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
    return attestation_ == null
        ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
        : attestation_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int GENERATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp generateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the generateTime field is set.
   */
  @java.lang.Override
  public boolean hasGenerateTime() {
    return generateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The generateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getGenerateTime() {
    return generateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : generateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * generated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
    return generateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : generateTime_;
  }

  public static final int DESTROY_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp destroyTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
   * scheduled for destruction. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyTime field is set.
   */
  @java.lang.Override
  public boolean hasDestroyTime() {
    return destroyTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
   * scheduled for destruction. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDestroyTime() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
   * scheduled for destruction. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
   * </pre>
   *
   * <code>.google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
    return destroyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : destroyTime_;
  }

  public static final int DESTROY_EVENT_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp destroyEventTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the destroyEventTime field is set.
   */
  @java.lang.Override
  public boolean hasDestroyEventTime() {
    return destroyEventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The destroyEventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDestroyEventTime() {
    return destroyEventTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : destroyEventTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time this CryptoKeyVersion's key material was
   * destroyed. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
    return destroyEventTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : destroyEventTime_;
  }

  public static final int IMPORT_JOB_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object importJob_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
   * used in the most recent import of this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
   * the underlying key material was imported.
   * </pre>
   *
   * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The importJob.
   */
  @java.lang.Override
  public java.lang.String getImportJob() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importJob_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
   * used in the most recent import of this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
   * the underlying key material was imported.
   * </pre>
   *
   * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for importJob.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImportJobBytes() {
    java.lang.Object ref = importJob_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importJob_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMPORT_TIME_FIELD_NUMBER = 15;
  private com.google.protobuf.Timestamp importTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * most recently imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the importTime field is set.
   */
  @java.lang.Override
  public boolean hasImportTime() {
    return importTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * most recently imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The importTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getImportTime() {
    return importTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : importTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
   * most recently imported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getImportTimeOrBuilder() {
    return importTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : importTime_;
  }

  public static final int IMPORT_FAILURE_REASON_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object importFailureReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent import failure. Only present
   * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
   * </pre>
   *
   * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The importFailureReason.
   */
  @java.lang.Override
  public java.lang.String getImportFailureReason() {
    java.lang.Object ref = importFailureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      importFailureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent import failure. Only present
   * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
   * </pre>
   *
   * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for importFailureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImportFailureReasonBytes() {
    java.lang.Object ref = importFailureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      importFailureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FAILURE_REASON_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object generationFailureReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent generation failure. Only
   * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
   * </pre>
   *
   * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The generationFailureReason.
   */
  @java.lang.Override
  public java.lang.String getGenerationFailureReason() {
    java.lang.Object ref = generationFailureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      generationFailureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent generation failure. Only
   * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
   * </pre>
   *
   * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for generationFailureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGenerationFailureReasonBytes() {
    java.lang.Object ref = generationFailureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      generationFailureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_DESTRUCTION_FAILURE_REASON_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalDestructionFailureReason_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent external destruction
   * failure. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
   * </pre>
   *
   * <code>
   * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The externalDestructionFailureReason.
   */
  @java.lang.Override
  public java.lang.String getExternalDestructionFailureReason() {
    java.lang.Object ref = externalDestructionFailureReason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalDestructionFailureReason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The root cause of the most recent external destruction
   * failure. Only present if
   * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
   * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
   * </pre>
   *
   * <code>
   * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for externalDestructionFailureReason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalDestructionFailureReasonBytes() {
    java.lang.Object ref = externalDestructionFailureReason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalDestructionFailureReason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_PROTECTION_LEVEL_OPTIONS_FIELD_NUMBER = 17;
  private com.google.cloud.kms.v1.ExternalProtectionLevelOptions externalProtectionLevelOptions_;
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
   * are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
   * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
   * protection levels.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   *
   * @return Whether the externalProtectionLevelOptions field is set.
   */
  @java.lang.Override
  public boolean hasExternalProtectionLevelOptions() {
    return externalProtectionLevelOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
   * are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
   * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
   * protection levels.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   *
   * @return The externalProtectionLevelOptions.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ExternalProtectionLevelOptions
      getExternalProtectionLevelOptions() {
    return externalProtectionLevelOptions_ == null
        ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
        : externalProtectionLevelOptions_;
  }
  /**
   *
   *
   * <pre>
   * ExternalProtectionLevelOptions stores a group of additional fields for
   * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
   * are specific to the
   * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
   * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
   * protection levels.
   * </pre>
   *
   * <code>
   * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder
      getExternalProtectionLevelOptionsOrBuilder() {
    return externalProtectionLevelOptions_ == null
        ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
        : externalProtectionLevelOptions_;
  }

  public static final int REIMPORT_ELIGIBLE_FIELD_NUMBER = 18;
  private boolean reimportEligible_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Whether or not this key version is eligible for reimport, by
   * being specified as a target in
   * [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
   * </pre>
   *
   * <code>bool reimport_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reimportEligible.
   */
  @java.lang.Override
  public boolean getReimportEligible() {
    return reimportEligible_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
            .CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      output.writeMessage(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      output.writeMessage(6, getDestroyEventTime());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, protectionLevel_);
    }
    if (attestation_ != null) {
      output.writeMessage(8, getAttestation());
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, algorithm_);
    }
    if (generateTime_ != null) {
      output.writeMessage(11, getGenerateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importJob_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, importJob_);
    }
    if (importTime_ != null) {
      output.writeMessage(15, getImportTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importFailureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, importFailureReason_);
    }
    if (externalProtectionLevelOptions_ != null) {
      output.writeMessage(17, getExternalProtectionLevelOptions());
    }
    if (reimportEligible_ != false) {
      output.writeBool(18, reimportEligible_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generationFailureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, generationFailureReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalDestructionFailureReason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 20, externalDestructionFailureReason_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState
            .CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (destroyTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDestroyTime());
    }
    if (destroyEventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDestroyEventTime());
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, protectionLevel_);
    }
    if (attestation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAttestation());
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, algorithm_);
    }
    if (generateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getGenerateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importJob_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, importJob_);
    }
    if (importTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getImportTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(importFailureReason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, importFailureReason_);
    }
    if (externalProtectionLevelOptions_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getExternalProtectionLevelOptions());
    }
    if (reimportEligible_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, reimportEligible_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generationFailureReason_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(19, generationFailureReason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalDestructionFailureReason_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              20, externalDestructionFailureReason_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.CryptoKeyVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.CryptoKeyVersion other = (com.google.cloud.kms.v1.CryptoKeyVersion) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (hasAttestation() != other.hasAttestation()) return false;
    if (hasAttestation()) {
      if (!getAttestation().equals(other.getAttestation())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasGenerateTime() != other.hasGenerateTime()) return false;
    if (hasGenerateTime()) {
      if (!getGenerateTime().equals(other.getGenerateTime())) return false;
    }
    if (hasDestroyTime() != other.hasDestroyTime()) return false;
    if (hasDestroyTime()) {
      if (!getDestroyTime().equals(other.getDestroyTime())) return false;
    }
    if (hasDestroyEventTime() != other.hasDestroyEventTime()) return false;
    if (hasDestroyEventTime()) {
      if (!getDestroyEventTime().equals(other.getDestroyEventTime())) return false;
    }
    if (!getImportJob().equals(other.getImportJob())) return false;
    if (hasImportTime() != other.hasImportTime()) return false;
    if (hasImportTime()) {
      if (!getImportTime().equals(other.getImportTime())) return false;
    }
    if (!getImportFailureReason().equals(other.getImportFailureReason())) return false;
    if (!getGenerationFailureReason().equals(other.getGenerationFailureReason())) return false;
    if (!getExternalDestructionFailureReason().equals(other.getExternalDestructionFailureReason()))
      return false;
    if (hasExternalProtectionLevelOptions() != other.hasExternalProtectionLevelOptions())
      return false;
    if (hasExternalProtectionLevelOptions()) {
      if (!getExternalProtectionLevelOptions().equals(other.getExternalProtectionLevelOptions()))
        return false;
    }
    if (getReimportEligible() != other.getReimportEligible()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    if (hasAttestation()) {
      hash = (37 * hash) + ATTESTATION_FIELD_NUMBER;
      hash = (53 * hash) + getAttestation().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasGenerateTime()) {
      hash = (37 * hash) + GENERATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getGenerateTime().hashCode();
    }
    if (hasDestroyTime()) {
      hash = (37 * hash) + DESTROY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyTime().hashCode();
    }
    if (hasDestroyEventTime()) {
      hash = (37 * hash) + DESTROY_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDestroyEventTime().hashCode();
    }
    hash = (37 * hash) + IMPORT_JOB_FIELD_NUMBER;
    hash = (53 * hash) + getImportJob().hashCode();
    if (hasImportTime()) {
      hash = (37 * hash) + IMPORT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getImportTime().hashCode();
    }
    hash = (37 * hash) + IMPORT_FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getImportFailureReason().hashCode();
    hash = (37 * hash) + GENERATION_FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getGenerationFailureReason().hashCode();
    hash = (37 * hash) + EXTERNAL_DESTRUCTION_FAILURE_REASON_FIELD_NUMBER;
    hash = (53 * hash) + getExternalDestructionFailureReason().hashCode();
    if (hasExternalProtectionLevelOptions()) {
      hash = (37 * hash) + EXTERNAL_PROTECTION_LEVEL_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExternalProtectionLevelOptions().hashCode();
    }
    hash = (37 * hash) + REIMPORT_ELIGIBLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReimportEligible());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.CryptoKeyVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an
   * individual cryptographic key, and the associated key material.
   *
   * An
   * [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
   * version can be used for cryptographic operations.
   *
   * For security reasons, the raw cryptographic key material represented by a
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed
   * or exported. It can only be used to encrypt, decrypt, or sign data when an
   * authorized user or application invokes Cloud KMS.
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.CryptoKeyVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.CryptoKeyVersion)
      com.google.cloud.kms.v1.CryptoKeyVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.CryptoKeyVersion.class,
              com.google.cloud.kms.v1.CryptoKeyVersion.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.CryptoKeyVersion.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      protectionLevel_ = 0;
      algorithm_ = 0;
      attestation_ = null;
      if (attestationBuilder_ != null) {
        attestationBuilder_.dispose();
        attestationBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      generateTime_ = null;
      if (generateTimeBuilder_ != null) {
        generateTimeBuilder_.dispose();
        generateTimeBuilder_ = null;
      }
      destroyTime_ = null;
      if (destroyTimeBuilder_ != null) {
        destroyTimeBuilder_.dispose();
        destroyTimeBuilder_ = null;
      }
      destroyEventTime_ = null;
      if (destroyEventTimeBuilder_ != null) {
        destroyEventTimeBuilder_.dispose();
        destroyEventTimeBuilder_ = null;
      }
      importJob_ = "";
      importTime_ = null;
      if (importTimeBuilder_ != null) {
        importTimeBuilder_.dispose();
        importTimeBuilder_ = null;
      }
      importFailureReason_ = "";
      generationFailureReason_ = "";
      externalDestructionFailureReason_ = "";
      externalProtectionLevelOptions_ = null;
      if (externalProtectionLevelOptionsBuilder_ != null) {
        externalProtectionLevelOptionsBuilder_.dispose();
        externalProtectionLevelOptionsBuilder_ = null;
      }
      reimportEligible_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_CryptoKeyVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion build() {
      com.google.cloud.kms.v1.CryptoKeyVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion buildPartial() {
      com.google.cloud.kms.v1.CryptoKeyVersion result =
          new com.google.cloud.kms.v1.CryptoKeyVersion(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.CryptoKeyVersion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.protectionLevel_ = protectionLevel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.algorithm_ = algorithm_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.attestation_ =
            attestationBuilder_ == null ? attestation_ : attestationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.generateTime_ =
            generateTimeBuilder_ == null ? generateTime_ : generateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.destroyTime_ =
            destroyTimeBuilder_ == null ? destroyTime_ : destroyTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.destroyEventTime_ =
            destroyEventTimeBuilder_ == null ? destroyEventTime_ : destroyEventTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.importJob_ = importJob_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.importTime_ = importTimeBuilder_ == null ? importTime_ : importTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.importFailureReason_ = importFailureReason_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.generationFailureReason_ = generationFailureReason_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.externalDestructionFailureReason_ = externalDestructionFailureReason_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.externalProtectionLevelOptions_ =
            externalProtectionLevelOptionsBuilder_ == null
                ? externalProtectionLevelOptions_
                : externalProtectionLevelOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.reimportEligible_ = reimportEligible_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.CryptoKeyVersion) {
        return mergeFrom((com.google.cloud.kms.v1.CryptoKeyVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.CryptoKeyVersion other) {
      if (other == com.google.cloud.kms.v1.CryptoKeyVersion.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (other.hasAttestation()) {
        mergeAttestation(other.getAttestation());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasGenerateTime()) {
        mergeGenerateTime(other.getGenerateTime());
      }
      if (other.hasDestroyTime()) {
        mergeDestroyTime(other.getDestroyTime());
      }
      if (other.hasDestroyEventTime()) {
        mergeDestroyEventTime(other.getDestroyEventTime());
      }
      if (!other.getImportJob().isEmpty()) {
        importJob_ = other.importJob_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasImportTime()) {
        mergeImportTime(other.getImportTime());
      }
      if (!other.getImportFailureReason().isEmpty()) {
        importFailureReason_ = other.importFailureReason_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getGenerationFailureReason().isEmpty()) {
        generationFailureReason_ = other.generationFailureReason_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getExternalDestructionFailureReason().isEmpty()) {
        externalDestructionFailureReason_ = other.externalDestructionFailureReason_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasExternalProtectionLevelOptions()) {
        mergeExternalProtectionLevelOptions(other.getExternalProtectionLevelOptions());
      }
      if (other.getReimportEligible() != false) {
        setReimportEligible(other.getReimportEligible());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDestroyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDestroyEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 50
            case 56:
              {
                protectionLevel_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getAttestationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            case 80:
              {
                algorithm_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getGenerateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 90
            case 114:
              {
                importJob_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getImportTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 122
            case 130:
              {
                importFailureReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getExternalProtectionLevelOptionsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 138
            case 144:
              {
                reimportEligible_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 144
            case 154:
              {
                generationFailureReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 154
            case 162:
              {
                externalDestructionFailureReason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name for this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
     * `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;&#47;cryptoKeyVersions/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The current state of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The current state of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState getState() {
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.forNumber(state_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The current state of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The current state of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
     * describing how crypto operations are performed with this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
     * describing how crypto operations are performed with this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {
      protectionLevel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
     * describing how crypto operations are performed with this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
     * describing how crypto operations are performed with this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
     * describing how crypto operations are performed with this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ProtectionLevel protection_level = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {
      bitField0_ = (bitField0_ & ~0x00000004);
      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The
     * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {
      algorithm_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(algorithm_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The
     * [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
     * supports.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000008);
      algorithm_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.KeyOperationAttestation attestation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        attestationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the attestation field is set.
     */
    public boolean hasAttestation() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The attestation.
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation getAttestation() {
      if (attestationBuilder_ == null) {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      } else {
        return attestationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attestation_ = value;
      } else {
        attestationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAttestation(
        com.google.cloud.kms.v1.KeyOperationAttestation.Builder builderForValue) {
      if (attestationBuilder_ == null) {
        attestation_ = builderForValue.build();
      } else {
        attestationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAttestation(com.google.cloud.kms.v1.KeyOperationAttestation value) {
      if (attestationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && attestation_ != null
            && attestation_
                != com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()) {
          getAttestationBuilder().mergeFrom(value);
        } else {
          attestation_ = value;
        }
      } else {
        attestationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAttestation() {
      bitField0_ = (bitField0_ & ~0x00000010);
      attestation_ = null;
      if (attestationBuilder_ != null) {
        attestationBuilder_.dispose();
        attestationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestation.Builder getAttestationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAttestationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder getAttestationOrBuilder() {
      if (attestationBuilder_ != null) {
        return attestationBuilder_.getMessageOrBuilder();
      } else {
        return attestation_ == null
            ? com.google.cloud.kms.v1.KeyOperationAttestation.getDefaultInstance()
            : attestation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statement that was generated and signed by the HSM at key
     * creation time. Use this statement to verify attributes of the key as stored
     * on the HSM, independently of Google. Only provided for key versions with
     * [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
     * [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.KeyOperationAttestation attestation = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.KeyOperationAttestation,
            com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
            com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>
        getAttestationFieldBuilder() {
      if (attestationBuilder_ == null) {
        attestationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.KeyOperationAttestation,
                com.google.cloud.kms.v1.KeyOperationAttestation.Builder,
                com.google.cloud.kms.v1.KeyOperationAttestationOrBuilder>(
                getAttestation(), getParentForChildren(), isClean());
        attestation_ = null;
      }
      return attestationBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp generateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        generateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the generateTime field is set.
     */
    public boolean hasGenerateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The generateTime.
     */
    public com.google.protobuf.Timestamp getGenerateTime() {
      if (generateTimeBuilder_ == null) {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      } else {
        return generateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generateTime_ = value;
      } else {
        generateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setGenerateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (generateTimeBuilder_ == null) {
        generateTime_ = builderForValue.build();
      } else {
        generateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeGenerateTime(com.google.protobuf.Timestamp value) {
      if (generateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && generateTime_ != null
            && generateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getGenerateTimeBuilder().mergeFrom(value);
        } else {
          generateTime_ = value;
        }
      } else {
        generateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearGenerateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      generateTime_ = null;
      if (generateTimeBuilder_ != null) {
        generateTimeBuilder_.dispose();
        generateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getGenerateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getGenerateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getGenerateTimeOrBuilder() {
      if (generateTimeBuilder_ != null) {
        return generateTimeBuilder_.getMessageOrBuilder();
      } else {
        return generateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : generateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * generated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp generate_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getGenerateTimeFieldBuilder() {
      if (generateTimeBuilder_ == null) {
        generateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getGenerateTime(), getParentForChildren(), isClean());
        generateTime_ = null;
      }
      return generateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyTime field is set.
     */
    public boolean hasDestroyTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyTime.
     */
    public com.google.protobuf.Timestamp getDestroyTime() {
      if (destroyTimeBuilder_ == null) {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      } else {
        return destroyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyTime_ = value;
      } else {
        destroyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyTimeBuilder_ == null) {
        destroyTime_ = builderForValue.build();
      } else {
        destroyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyTime(com.google.protobuf.Timestamp value) {
      if (destroyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && destroyTime_ != null
            && destroyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDestroyTimeBuilder().mergeFrom(value);
        } else {
          destroyTime_ = value;
        }
      } else {
        destroyTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      destroyTime_ = null;
      if (destroyTimeBuilder_ != null) {
        destroyTimeBuilder_.dispose();
        destroyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDestroyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyTimeOrBuilder() {
      if (destroyTimeBuilder_ != null) {
        return destroyTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
     * scheduled for destruction. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyTimeFieldBuilder() {
      if (destroyTimeBuilder_ == null) {
        destroyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyTime(), getParentForChildren(), isClean());
        destroyTime_ = null;
      }
      return destroyTimeBuilder_;
    }

    private com.google.protobuf.Timestamp destroyEventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        destroyEventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the destroyEventTime field is set.
     */
    public boolean hasDestroyEventTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The destroyEventTime.
     */
    public com.google.protobuf.Timestamp getDestroyEventTime() {
      if (destroyEventTimeBuilder_ == null) {
        return destroyEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyEventTime_;
      } else {
        return destroyEventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destroyEventTime_ = value;
      } else {
        destroyEventTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDestroyEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTime_ = builderForValue.build();
      } else {
        destroyEventTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDestroyEventTime(com.google.protobuf.Timestamp value) {
      if (destroyEventTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && destroyEventTime_ != null
            && destroyEventTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDestroyEventTimeBuilder().mergeFrom(value);
        } else {
          destroyEventTime_ = value;
        }
      } else {
        destroyEventTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDestroyEventTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      destroyEventTime_ = null;
      if (destroyEventTimeBuilder_ != null) {
        destroyEventTimeBuilder_.dispose();
        destroyEventTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDestroyEventTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDestroyEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDestroyEventTimeOrBuilder() {
      if (destroyEventTimeBuilder_ != null) {
        return destroyEventTimeBuilder_.getMessageOrBuilder();
      } else {
        return destroyEventTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : destroyEventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time this CryptoKeyVersion's key material was
     * destroyed. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp destroy_event_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDestroyEventTimeFieldBuilder() {
      if (destroyEventTimeBuilder_ == null) {
        destroyEventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDestroyEventTime(), getParentForChildren(), isClean());
        destroyEventTime_ = null;
      }
      return destroyEventTimeBuilder_;
    }

    private java.lang.Object importJob_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
     * used in the most recent import of this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
     * the underlying key material was imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The importJob.
     */
    public java.lang.String getImportJob() {
      java.lang.Object ref = importJob_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importJob_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
     * used in the most recent import of this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
     * the underlying key material was imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for importJob.
     */
    public com.google.protobuf.ByteString getImportJobBytes() {
      java.lang.Object ref = importJob_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
     * used in the most recent import of this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
     * the underlying key material was imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJob(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      importJob_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
     * used in the most recent import of this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
     * the underlying key material was imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportJob() {
      importJob_ = getDefaultInstance().getImportJob();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [ImportJob][google.cloud.kms.v1.ImportJob]
     * used in the most recent import of this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Only present if
     * the underlying key material was imported.
     * </pre>
     *
     * <code>string import_job = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for importJob to set.
     * @return This builder for chaining.
     */
    public Builder setImportJobBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      importJob_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp importTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        importTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the importTime field is set.
     */
    public boolean hasImportTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The importTime.
     */
    public com.google.protobuf.Timestamp getImportTime() {
      if (importTimeBuilder_ == null) {
        return importTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importTime_;
      } else {
        return importTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportTime(com.google.protobuf.Timestamp value) {
      if (importTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        importTime_ = value;
      } else {
        importTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setImportTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (importTimeBuilder_ == null) {
        importTime_ = builderForValue.build();
      } else {
        importTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeImportTime(com.google.protobuf.Timestamp value) {
      if (importTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && importTime_ != null
            && importTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getImportTimeBuilder().mergeFrom(value);
        } else {
          importTime_ = value;
        }
      } else {
        importTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearImportTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      importTime_ = null;
      if (importTimeBuilder_ != null) {
        importTimeBuilder_.dispose();
        importTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getImportTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getImportTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getImportTimeOrBuilder() {
      if (importTimeBuilder_ != null) {
        return importTimeBuilder_.getMessageOrBuilder();
      } else {
        return importTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : importTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
     * most recently imported.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp import_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getImportTimeFieldBuilder() {
      if (importTimeBuilder_ == null) {
        importTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getImportTime(), getParentForChildren(), isClean());
        importTime_ = null;
      }
      return importTimeBuilder_;
    }

    private java.lang.Object importFailureReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent import failure. Only present
     * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The importFailureReason.
     */
    public java.lang.String getImportFailureReason() {
      java.lang.Object ref = importFailureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        importFailureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent import failure. Only present
     * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for importFailureReason.
     */
    public com.google.protobuf.ByteString getImportFailureReasonBytes() {
      java.lang.Object ref = importFailureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        importFailureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent import failure. Only present
     * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The importFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setImportFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      importFailureReason_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent import failure. Only present
     * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportFailureReason() {
      importFailureReason_ = getDefaultInstance().getImportFailureReason();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent import failure. Only present
     * if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [IMPORT_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.IMPORT_FAILED].
     * </pre>
     *
     * <code>string import_failure_reason = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for importFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setImportFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      importFailureReason_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object generationFailureReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent generation failure. Only
     * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
     * </pre>
     *
     * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The generationFailureReason.
     */
    public java.lang.String getGenerationFailureReason() {
      java.lang.Object ref = generationFailureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generationFailureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent generation failure. Only
     * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
     * </pre>
     *
     * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for generationFailureReason.
     */
    public com.google.protobuf.ByteString getGenerationFailureReasonBytes() {
      java.lang.Object ref = generationFailureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generationFailureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent generation failure. Only
     * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
     * </pre>
     *
     * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The generationFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setGenerationFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      generationFailureReason_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent generation failure. Only
     * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
     * </pre>
     *
     * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGenerationFailureReason() {
      generationFailureReason_ = getDefaultInstance().getGenerationFailureReason();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent generation failure. Only
     * present if [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [GENERATION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.GENERATION_FAILED].
     * </pre>
     *
     * <code>string generation_failure_reason = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for generationFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setGenerationFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      generationFailureReason_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object externalDestructionFailureReason_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent external destruction
     * failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
     * </pre>
     *
     * <code>
     * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The externalDestructionFailureReason.
     */
    public java.lang.String getExternalDestructionFailureReason() {
      java.lang.Object ref = externalDestructionFailureReason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalDestructionFailureReason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent external destruction
     * failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
     * </pre>
     *
     * <code>
     * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for externalDestructionFailureReason.
     */
    public com.google.protobuf.ByteString getExternalDestructionFailureReasonBytes() {
      java.lang.Object ref = externalDestructionFailureReason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalDestructionFailureReason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent external destruction
     * failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
     * </pre>
     *
     * <code>
     * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The externalDestructionFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setExternalDestructionFailureReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalDestructionFailureReason_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent external destruction
     * failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
     * </pre>
     *
     * <code>
     * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalDestructionFailureReason() {
      externalDestructionFailureReason_ =
          getDefaultInstance().getExternalDestructionFailureReason();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The root cause of the most recent external destruction
     * failure. Only present if
     * [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
     * [EXTERNAL_DESTRUCTION_FAILED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.EXTERNAL_DESTRUCTION_FAILED].
     * </pre>
     *
     * <code>
     * string external_destruction_failure_reason = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for externalDestructionFailureReason to set.
     * @return This builder for chaining.
     */
    public Builder setExternalDestructionFailureReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalDestructionFailureReason_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.ExternalProtectionLevelOptions externalProtectionLevelOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>
        externalProtectionLevelOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     *
     * @return Whether the externalProtectionLevelOptions field is set.
     */
    public boolean hasExternalProtectionLevelOptions() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     *
     * @return The externalProtectionLevelOptions.
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptions
        getExternalProtectionLevelOptions() {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        return externalProtectionLevelOptions_ == null
            ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
            : externalProtectionLevelOptions_;
      } else {
        return externalProtectionLevelOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder setExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions value) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        externalProtectionLevelOptions_ = value;
      } else {
        externalProtectionLevelOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder setExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder builderForValue) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptions_ = builderForValue.build();
      } else {
        externalProtectionLevelOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder mergeExternalProtectionLevelOptions(
        com.google.cloud.kms.v1.ExternalProtectionLevelOptions value) {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && externalProtectionLevelOptions_ != null
            && externalProtectionLevelOptions_
                != com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()) {
          getExternalProtectionLevelOptionsBuilder().mergeFrom(value);
        } else {
          externalProtectionLevelOptions_ = value;
        }
      } else {
        externalProtectionLevelOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public Builder clearExternalProtectionLevelOptions() {
      bitField0_ = (bitField0_ & ~0x00004000);
      externalProtectionLevelOptions_ = null;
      if (externalProtectionLevelOptionsBuilder_ != null) {
        externalProtectionLevelOptionsBuilder_.dispose();
        externalProtectionLevelOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder
        getExternalProtectionLevelOptionsBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getExternalProtectionLevelOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    public com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder
        getExternalProtectionLevelOptionsOrBuilder() {
      if (externalProtectionLevelOptionsBuilder_ != null) {
        return externalProtectionLevelOptionsBuilder_.getMessageOrBuilder();
      } else {
        return externalProtectionLevelOptions_ == null
            ? com.google.cloud.kms.v1.ExternalProtectionLevelOptions.getDefaultInstance()
            : externalProtectionLevelOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * ExternalProtectionLevelOptions stores a group of additional fields for
     * configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
     * are specific to the
     * [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL] protection level
     * and [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC]
     * protection levels.
     * </pre>
     *
     * <code>
     * .google.cloud.kms.v1.ExternalProtectionLevelOptions external_protection_level_options = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
            com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>
        getExternalProtectionLevelOptionsFieldBuilder() {
      if (externalProtectionLevelOptionsBuilder_ == null) {
        externalProtectionLevelOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.ExternalProtectionLevelOptions,
                com.google.cloud.kms.v1.ExternalProtectionLevelOptions.Builder,
                com.google.cloud.kms.v1.ExternalProtectionLevelOptionsOrBuilder>(
                getExternalProtectionLevelOptions(), getParentForChildren(), isClean());
        externalProtectionLevelOptions_ = null;
      }
      return externalProtectionLevelOptionsBuilder_;
    }

    private boolean reimportEligible_;
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this key version is eligible for reimport, by
     * being specified as a target in
     * [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
     * </pre>
     *
     * <code>bool reimport_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reimportEligible.
     */
    @java.lang.Override
    public boolean getReimportEligible() {
      return reimportEligible_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this key version is eligible for reimport, by
     * being specified as a target in
     * [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
     * </pre>
     *
     * <code>bool reimport_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reimportEligible to set.
     * @return This builder for chaining.
     */
    public Builder setReimportEligible(boolean value) {

      reimportEligible_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Whether or not this key version is eligible for reimport, by
     * being specified as a target in
     * [ImportCryptoKeyVersionRequest.crypto_key_version][google.cloud.kms.v1.ImportCryptoKeyVersionRequest.crypto_key_version].
     * </pre>
     *
     * <code>bool reimport_eligible = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReimportEligible() {
      bitField0_ = (bitField0_ & ~0x00008000);
      reimportEligible_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.CryptoKeyVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.CryptoKeyVersion)
  private static final com.google.cloud.kms.v1.CryptoKeyVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.CryptoKeyVersion();
  }

  public static com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoKeyVersion> PARSER =
      new com.google.protobuf.AbstractParser<CryptoKeyVersion>() {
        @java.lang.Override
        public CryptoKeyVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CryptoKeyVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoKeyVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
