/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeviceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REGISTRY_DEVICE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/registries/{registry}/devices/{device}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String registry;
    private final String device;

    @Deprecated
    protected DeviceName() {
        this.project = null;
        this.location = null;
        this.registry = null;
        this.device = null;
    }

    private DeviceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.registry = (String)Preconditions.checkNotNull((Object)builder.getRegistry());
        this.device = (String)Preconditions.checkNotNull((Object)builder.getDevice());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getDevice() {
        return this.device;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceName of(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build();
    }

    public static String format(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build().toString();
    }

    public static DeviceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REGISTRY_DEVICE.validatedMatch(formattedString, "DeviceName.parse: formattedString not in valid format");
        return DeviceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("registry"), (String)matchMap.get("device"));
    }

    public static List<DeviceName> parseList(List<String> formattedStrings) {
        ArrayList<DeviceName> list = new ArrayList<DeviceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeviceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeviceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeviceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REGISTRY_DEVICE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeviceName deviceName = this;
            synchronized (deviceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.registry != null) {
                        fieldMapBuilder.put((Object)"registry", (Object)this.registry);
                    }
                    if (this.device != null) {
                        fieldMapBuilder.put((Object)"device", (Object)this.device);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REGISTRY_DEVICE.instantiate(new String[]{"project", this.project, "location", this.location, "registry", this.registry, "device", this.device});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeviceName that = (DeviceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.registry, that.registry) && Objects.equals(this.device, that.device);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.registry);
        h *= 1000003;
        return h ^= Objects.hashCode(this.device);
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;
        private String device;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public String getDevice() {
            return this.device;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        public Builder setDevice(String device) {
            this.device = device;
            return this;
        }

        private Builder(DeviceName deviceName) {
            this.project = deviceName.project;
            this.location = deviceName.location;
            this.registry = deviceName.registry;
            this.device = deviceName.device;
        }

        public DeviceName build() {
            return new DeviceName(this);
        }
    }
}

