/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegistryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REGISTRY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/registries/{registry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String registry;

    @Deprecated
    protected RegistryName() {
        this.project = null;
        this.location = null;
        this.registry = null;
    }

    private RegistryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.registry = (String)Preconditions.checkNotNull((Object)builder.getRegistry());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RegistryName of(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build();
    }

    public static String format(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build().toString();
    }

    public static RegistryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REGISTRY.validatedMatch(formattedString, "RegistryName.parse: formattedString not in valid format");
        return RegistryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("registry"));
    }

    public static List<RegistryName> parseList(List<String> formattedStrings) {
        ArrayList<RegistryName> list = new ArrayList<RegistryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RegistryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RegistryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RegistryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REGISTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RegistryName registryName = this;
            synchronized (registryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.registry != null) {
                        fieldMapBuilder.put((Object)"registry", (Object)this.registry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REGISTRY.instantiate(new String[]{"project", this.project, "location", this.location, "registry", this.registry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RegistryName that = (RegistryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.registry, that.registry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.registry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        private Builder(RegistryName registryName) {
            this.project = registryName.project;
            this.location = registryName.location;
            this.registry = registryName.registry;
        }

        public RegistryName build() {
            return new RegistryName(this);
        }
    }
}

