/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RegistryName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/registries/{registry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String registry;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private RegistryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.registry = (String)Preconditions.checkNotNull((Object)builder.getRegistry());
    }

    public static RegistryName of(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build();
    }

    public static String format(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build().toString();
    }

    public static RegistryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "RegistryName.parse: formattedString not in valid format");
        return RegistryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("registry"));
    }

    public static List<RegistryName> parseList(List<String> formattedStrings) {
        ArrayList<RegistryName> list = new ArrayList<RegistryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RegistryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RegistryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RegistryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RegistryName registryName = this;
            synchronized (registryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"registry", (Object)this.registry);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "registry", this.registry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RegistryName) {
            RegistryName that = (RegistryName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.registry.equals(that.registry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.registry.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        private Builder() {
        }

        private Builder(RegistryName registryName) {
            this.project = registryName.project;
            this.location = registryName.location;
            this.registry = registryName.registry;
        }

        public RegistryName build() {
            return new RegistryName(this);
        }
    }
}

