/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceChangeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PREVIEW_RESOURCE_CHANGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/previews/{preview}/resourceChanges/{resource_change}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String preview;
    private final String resourceChange;

    @Deprecated
    protected ResourceChangeName() {
        this.project = null;
        this.location = null;
        this.preview = null;
        this.resourceChange = null;
    }

    private ResourceChangeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.preview = (String)Preconditions.checkNotNull((Object)builder.getPreview());
        this.resourceChange = (String)Preconditions.checkNotNull((Object)builder.getResourceChange());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPreview() {
        return this.preview;
    }

    public String getResourceChange() {
        return this.resourceChange;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceChangeName of(String project, String location, String preview, String resourceChange) {
        return ResourceChangeName.newBuilder().setProject(project).setLocation(location).setPreview(preview).setResourceChange(resourceChange).build();
    }

    public static String format(String project, String location, String preview, String resourceChange) {
        return ResourceChangeName.newBuilder().setProject(project).setLocation(location).setPreview(preview).setResourceChange(resourceChange).build().toString();
    }

    public static ResourceChangeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PREVIEW_RESOURCE_CHANGE.validatedMatch(formattedString, "ResourceChangeName.parse: formattedString not in valid format");
        return ResourceChangeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("preview"), (String)matchMap.get("resource_change"));
    }

    public static List<ResourceChangeName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceChangeName> list = new ArrayList<ResourceChangeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceChangeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceChangeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceChangeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PREVIEW_RESOURCE_CHANGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceChangeName resourceChangeName = this;
            synchronized (resourceChangeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.preview != null) {
                        fieldMapBuilder.put((Object)"preview", (Object)this.preview);
                    }
                    if (this.resourceChange != null) {
                        fieldMapBuilder.put((Object)"resource_change", (Object)this.resourceChange);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PREVIEW_RESOURCE_CHANGE.instantiate(new String[]{"project", this.project, "location", this.location, "preview", this.preview, "resource_change", this.resourceChange});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceChangeName that = (ResourceChangeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.preview, that.preview) && Objects.equals(this.resourceChange, that.resourceChange);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.preview);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resourceChange);
    }

    public static class Builder {
        private String project;
        private String location;
        private String preview;
        private String resourceChange;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPreview() {
            return this.preview;
        }

        public String getResourceChange() {
            return this.resourceChange;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPreview(String preview) {
            this.preview = preview;
            return this;
        }

        public Builder setResourceChange(String resourceChange) {
            this.resourceChange = resourceChange;
            return this;
        }

        private Builder(ResourceChangeName resourceChangeName) {
            this.project = resourceChangeName.project;
            this.location = resourceChangeName.location;
            this.preview = resourceChangeName.preview;
            this.resourceChange = resourceChangeName.resourceChange;
        }

        public ResourceChangeName build() {
            return new ResourceChangeName(this);
        }
    }
}

