/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceName
implements com.google.api.resourcenames.ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DEPLOYMENT_REVISION_RESOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deployment;
    private final String revision;
    private final String resource;

    @Deprecated
    protected ResourceName() {
        this.project = null;
        this.location = null;
        this.deployment = null;
        this.revision = null;
        this.resource = null;
    }

    private ResourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
        this.revision = (String)Preconditions.checkNotNull((Object)builder.getRevision());
        this.resource = (String)Preconditions.checkNotNull((Object)builder.getResource());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getResource() {
        return this.resource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ResourceName of(String project, String location, String deployment, String revision, String resource) {
        return ResourceName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).setRevision(revision).setResource(resource).build();
    }

    public static String format(String project, String location, String deployment, String revision, String resource) {
        return ResourceName.newBuilder().setProject(project).setLocation(location).setDeployment(deployment).setRevision(revision).setResource(resource).build().toString();
    }

    public static ResourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DEPLOYMENT_REVISION_RESOURCE.validatedMatch(formattedString, "ResourceName.parse: formattedString not in valid format");
        return ResourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("deployment"), (String)matchMap.get("revision"), (String)matchMap.get("resource"));
    }

    public static List<ResourceName> parseList(List<String> formattedStrings) {
        ArrayList<ResourceName> list = new ArrayList<ResourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ResourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ResourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ResourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DEPLOYMENT_REVISION_RESOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ResourceName resourceName = this;
            synchronized (resourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    if (this.revision != null) {
                        fieldMapBuilder.put((Object)"revision", (Object)this.revision);
                    }
                    if (this.resource != null) {
                        fieldMapBuilder.put((Object)"resource", (Object)this.resource);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DEPLOYMENT_REVISION_RESOURCE.instantiate(new String[]{"project", this.project, "location", this.location, "deployment", this.deployment, "revision", this.revision, "resource", this.resource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ResourceName that = (ResourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deployment, that.deployment) && Objects.equals(this.revision, that.revision) && Objects.equals(this.resource, that.resource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deployment);
        h *= 1000003;
        h ^= Objects.hashCode(this.revision);
        h *= 1000003;
        return h ^= Objects.hashCode(this.resource);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deployment;
        private String revision;
        private String resource;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getResource() {
            return this.resource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        private Builder(ResourceName resourceName) {
            this.project = resourceName.project;
            this.location = resourceName.location;
            this.deployment = resourceName.deployment;
            this.revision = resourceName.revision;
            this.resource = resourceName.resource;
        }

        public ResourceName build() {
            return new ResourceName(this);
        }
    }
}

