/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PreviewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PREVIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/previews/{preview}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String preview;

    @Deprecated
    protected PreviewName() {
        this.project = null;
        this.location = null;
        this.preview = null;
    }

    private PreviewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.preview = (String)Preconditions.checkNotNull((Object)builder.getPreview());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPreview() {
        return this.preview;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PreviewName of(String project, String location, String preview) {
        return PreviewName.newBuilder().setProject(project).setLocation(location).setPreview(preview).build();
    }

    public static String format(String project, String location, String preview) {
        return PreviewName.newBuilder().setProject(project).setLocation(location).setPreview(preview).build().toString();
    }

    public static PreviewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PREVIEW.validatedMatch(formattedString, "PreviewName.parse: formattedString not in valid format");
        return PreviewName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("preview"));
    }

    public static List<PreviewName> parseList(List<String> formattedStrings) {
        ArrayList<PreviewName> list = new ArrayList<PreviewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PreviewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PreviewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PreviewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PREVIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PreviewName previewName = this;
            synchronized (previewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.preview != null) {
                        fieldMapBuilder.put((Object)"preview", (Object)this.preview);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PREVIEW.instantiate(new String[]{"project", this.project, "location", this.location, "preview", this.preview});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PreviewName that = (PreviewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.preview, that.preview);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.preview);
    }

    public static class Builder {
        private String project;
        private String location;
        private String preview;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPreview() {
            return this.preview;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPreview(String preview) {
            this.preview = preview;
            return this;
        }

        private Builder(PreviewName previewName) {
            this.project = previewName.project;
            this.location = previewName.location;
            this.preview = previewName.preview;
        }

        public PreviewName build() {
            return new PreviewName(this);
        }
    }
}

