/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.ids.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EndpointName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENDPOINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/endpoints/{endpoint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String endpoint;

    @Deprecated
    protected EndpointName() {
        this.project = null;
        this.location = null;
        this.endpoint = null;
    }

    private EndpointName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.endpoint = (String)Preconditions.checkNotNull((Object)builder.getEndpoint());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EndpointName of(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build();
    }

    public static String format(String project, String location, String endpoint) {
        return EndpointName.newBuilder().setProject(project).setLocation(location).setEndpoint(endpoint).build().toString();
    }

    public static EndpointName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENDPOINT.validatedMatch(formattedString, "EndpointName.parse: formattedString not in valid format");
        return EndpointName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("endpoint"));
    }

    public static List<EndpointName> parseList(List<String> formattedStrings) {
        ArrayList<EndpointName> list = new ArrayList<EndpointName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EndpointName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EndpointName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EndpointName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENDPOINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EndpointName endpointName = this;
            synchronized (endpointName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.endpoint != null) {
                        fieldMapBuilder.put((Object)"endpoint", (Object)this.endpoint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENDPOINT.instantiate(new String[]{"project", this.project, "location", this.location, "endpoint", this.endpoint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EndpointName that = (EndpointName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.endpoint, that.endpoint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.endpoint);
    }

    public static class Builder {
        private String project;
        private String location;
        private String endpoint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        private Builder(EndpointName endpointName) {
            this.project = endpointName.project;
            this.location = endpointName.location;
            this.endpoint = endpointName.endpoint;
        }

        public EndpointName build() {
            return new EndpointName(this);
        }
    }
}

