/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gsuiteaddons.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeploymentName
implements ResourceName {
    private static final PathTemplate PROJECT_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/deployments/{deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String deployment;

    @Deprecated
    protected DeploymentName() {
        this.project = null;
        this.deployment = null;
    }

    private DeploymentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
    }

    public String getProject() {
        return this.project;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeploymentName of(String project, String deployment) {
        return DeploymentName.newBuilder().setProject(project).setDeployment(deployment).build();
    }

    public static String format(String project, String deployment) {
        return DeploymentName.newBuilder().setProject(project).setDeployment(deployment).build().toString();
    }

    public static DeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DEPLOYMENT.validatedMatch(formattedString, "DeploymentName.parse: formattedString not in valid format");
        return DeploymentName.of((String)matchMap.get("project"), (String)matchMap.get("deployment"));
    }

    public static List<DeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<DeploymentName> list = new ArrayList<DeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeploymentName deploymentName = this;
            synchronized (deploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DEPLOYMENT.instantiate(new String[]{"project", this.project, "deployment", this.deployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DeploymentName that = (DeploymentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.deployment, that.deployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.deployment);
    }

    public static class Builder {
        private String project;
        private String deployment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        private Builder(DeploymentName deploymentName) {
            this.project = deploymentName.project;
            this.deployment = deploymentName.deployment;
        }

        public DeploymentName build() {
            return new DeploymentName(this);
        }
    }
}

