/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AzureClientName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AZURE_CLIENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/azureClients/{azure_client}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String azureClient;

    @Deprecated
    protected AzureClientName() {
        this.project = null;
        this.location = null;
        this.azureClient = null;
    }

    private AzureClientName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.azureClient = (String)Preconditions.checkNotNull((Object)builder.getAzureClient());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAzureClient() {
        return this.azureClient;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AzureClientName of(String project, String location, String azureClient) {
        return AzureClientName.newBuilder().setProject(project).setLocation(location).setAzureClient(azureClient).build();
    }

    public static String format(String project, String location, String azureClient) {
        return AzureClientName.newBuilder().setProject(project).setLocation(location).setAzureClient(azureClient).build().toString();
    }

    public static AzureClientName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AZURE_CLIENT.validatedMatch(formattedString, "AzureClientName.parse: formattedString not in valid format");
        return AzureClientName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("azure_client"));
    }

    public static List<AzureClientName> parseList(List<String> formattedStrings) {
        ArrayList<AzureClientName> list = new ArrayList<AzureClientName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AzureClientName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AzureClientName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AzureClientName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AZURE_CLIENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AzureClientName azureClientName = this;
            synchronized (azureClientName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.azureClient != null) {
                        fieldMapBuilder.put((Object)"azure_client", (Object)this.azureClient);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AZURE_CLIENT.instantiate(new String[]{"project", this.project, "location", this.location, "azure_client", this.azureClient});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AzureClientName that = (AzureClientName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.azureClient, that.azureClient);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.azureClient);
    }

    public static class Builder {
        private String project;
        private String location;
        private String azureClient;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAzureClient() {
            return this.azureClient;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAzureClient(String azureClient) {
            this.azureClient = azureClient;
            return this;
        }

        private Builder(AzureClientName azureClientName) {
            this.project = azureClientName.project;
            this.location = azureClientName.location;
            this.azureClient = azureClientName.azureClient;
        }

        public AzureClientName build() {
            return new AzureClientName(this);
        }
    }
}

