/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AzureClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AZURE_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/azureClusters/{azure_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String azureCluster;

    @Deprecated
    protected AzureClusterName() {
        this.project = null;
        this.location = null;
        this.azureCluster = null;
    }

    private AzureClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.azureCluster = (String)Preconditions.checkNotNull((Object)builder.getAzureCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAzureCluster() {
        return this.azureCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AzureClusterName of(String project, String location, String azureCluster) {
        return AzureClusterName.newBuilder().setProject(project).setLocation(location).setAzureCluster(azureCluster).build();
    }

    public static String format(String project, String location, String azureCluster) {
        return AzureClusterName.newBuilder().setProject(project).setLocation(location).setAzureCluster(azureCluster).build().toString();
    }

    public static AzureClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AZURE_CLUSTER.validatedMatch(formattedString, "AzureClusterName.parse: formattedString not in valid format");
        return AzureClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("azure_cluster"));
    }

    public static List<AzureClusterName> parseList(List<String> formattedStrings) {
        ArrayList<AzureClusterName> list = new ArrayList<AzureClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AzureClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AzureClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AzureClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AZURE_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AzureClusterName azureClusterName = this;
            synchronized (azureClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.azureCluster != null) {
                        fieldMapBuilder.put((Object)"azure_cluster", (Object)this.azureCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AZURE_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "azure_cluster", this.azureCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AzureClusterName that = (AzureClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.azureCluster, that.azureCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.azureCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String azureCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAzureCluster() {
            return this.azureCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAzureCluster(String azureCluster) {
            this.azureCluster = azureCluster;
            return this;
        }

        private Builder(AzureClusterName azureClusterName) {
            this.project = azureClusterName.project;
            this.location = azureClusterName.location;
            this.azureCluster = azureClusterName.azureCluster;
        }

        public AzureClusterName build() {
            return new AzureClusterName(this);
        }
    }
}

