/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AzureNodePoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AZURE_CLUSTER_AZURE_NODE_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/azureClusters/{azure_cluster}/azureNodePools/{azure_node_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String azureCluster;
    private final String azureNodePool;

    @Deprecated
    protected AzureNodePoolName() {
        this.project = null;
        this.location = null;
        this.azureCluster = null;
        this.azureNodePool = null;
    }

    private AzureNodePoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.azureCluster = (String)Preconditions.checkNotNull((Object)builder.getAzureCluster());
        this.azureNodePool = (String)Preconditions.checkNotNull((Object)builder.getAzureNodePool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAzureCluster() {
        return this.azureCluster;
    }

    public String getAzureNodePool() {
        return this.azureNodePool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AzureNodePoolName of(String project, String location, String azureCluster, String azureNodePool) {
        return AzureNodePoolName.newBuilder().setProject(project).setLocation(location).setAzureCluster(azureCluster).setAzureNodePool(azureNodePool).build();
    }

    public static String format(String project, String location, String azureCluster, String azureNodePool) {
        return AzureNodePoolName.newBuilder().setProject(project).setLocation(location).setAzureCluster(azureCluster).setAzureNodePool(azureNodePool).build().toString();
    }

    public static AzureNodePoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AZURE_CLUSTER_AZURE_NODE_POOL.validatedMatch(formattedString, "AzureNodePoolName.parse: formattedString not in valid format");
        return AzureNodePoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("azure_cluster"), (String)matchMap.get("azure_node_pool"));
    }

    public static List<AzureNodePoolName> parseList(List<String> formattedStrings) {
        ArrayList<AzureNodePoolName> list = new ArrayList<AzureNodePoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AzureNodePoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AzureNodePoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AzureNodePoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AZURE_CLUSTER_AZURE_NODE_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AzureNodePoolName azureNodePoolName = this;
            synchronized (azureNodePoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.azureCluster != null) {
                        fieldMapBuilder.put((Object)"azure_cluster", (Object)this.azureCluster);
                    }
                    if (this.azureNodePool != null) {
                        fieldMapBuilder.put((Object)"azure_node_pool", (Object)this.azureNodePool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AZURE_CLUSTER_AZURE_NODE_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "azure_cluster", this.azureCluster, "azure_node_pool", this.azureNodePool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AzureNodePoolName that = (AzureNodePoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.azureCluster, that.azureCluster) && Objects.equals(this.azureNodePool, that.azureNodePool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.azureCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.azureNodePool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String azureCluster;
        private String azureNodePool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAzureCluster() {
            return this.azureCluster;
        }

        public String getAzureNodePool() {
            return this.azureNodePool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAzureCluster(String azureCluster) {
            this.azureCluster = azureCluster;
            return this;
        }

        public Builder setAzureNodePool(String azureNodePool) {
            this.azureNodePool = azureNodePool;
            return this;
        }

        private Builder(AzureNodePoolName azureNodePoolName) {
            this.project = azureNodePoolName.project;
            this.location = azureNodePoolName.location;
            this.azureCluster = azureNodePoolName.azureCluster;
            this.azureNodePool = azureNodePoolName.azureNodePool;
        }

        public AzureNodePoolName build() {
            return new AzureNodePoolName(this);
        }
    }
}

