/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestorePlanBindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESTORE_CHANNEL_RESTORE_PLAN_BINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/restoreChannels/{restore_channel}/restorePlanBindings/{restore_plan_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String restoreChannel;
    private final String restorePlanBinding;

    @Deprecated
    protected RestorePlanBindingName() {
        this.project = null;
        this.location = null;
        this.restoreChannel = null;
        this.restorePlanBinding = null;
    }

    private RestorePlanBindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.restoreChannel = (String)Preconditions.checkNotNull((Object)builder.getRestoreChannel());
        this.restorePlanBinding = (String)Preconditions.checkNotNull((Object)builder.getRestorePlanBinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRestoreChannel() {
        return this.restoreChannel;
    }

    public String getRestorePlanBinding() {
        return this.restorePlanBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RestorePlanBindingName of(String project, String location, String restoreChannel, String restorePlanBinding) {
        return RestorePlanBindingName.newBuilder().setProject(project).setLocation(location).setRestoreChannel(restoreChannel).setRestorePlanBinding(restorePlanBinding).build();
    }

    public static String format(String project, String location, String restoreChannel, String restorePlanBinding) {
        return RestorePlanBindingName.newBuilder().setProject(project).setLocation(location).setRestoreChannel(restoreChannel).setRestorePlanBinding(restorePlanBinding).build().toString();
    }

    public static RestorePlanBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESTORE_CHANNEL_RESTORE_PLAN_BINDING.validatedMatch(formattedString, "RestorePlanBindingName.parse: formattedString not in valid format");
        return RestorePlanBindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("restore_channel"), (String)matchMap.get("restore_plan_binding"));
    }

    public static List<RestorePlanBindingName> parseList(List<String> formattedStrings) {
        ArrayList<RestorePlanBindingName> list = new ArrayList<RestorePlanBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RestorePlanBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RestorePlanBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RestorePlanBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESTORE_CHANNEL_RESTORE_PLAN_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RestorePlanBindingName restorePlanBindingName = this;
            synchronized (restorePlanBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.restoreChannel != null) {
                        fieldMapBuilder.put((Object)"restore_channel", (Object)this.restoreChannel);
                    }
                    if (this.restorePlanBinding != null) {
                        fieldMapBuilder.put((Object)"restore_plan_binding", (Object)this.restorePlanBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESTORE_CHANNEL_RESTORE_PLAN_BINDING.instantiate(new String[]{"project", this.project, "location", this.location, "restore_channel", this.restoreChannel, "restore_plan_binding", this.restorePlanBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RestorePlanBindingName that = (RestorePlanBindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.restoreChannel, that.restoreChannel) && Objects.equals(this.restorePlanBinding, that.restorePlanBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.restoreChannel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.restorePlanBinding);
    }

    public static class Builder {
        private String project;
        private String location;
        private String restoreChannel;
        private String restorePlanBinding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRestoreChannel() {
            return this.restoreChannel;
        }

        public String getRestorePlanBinding() {
            return this.restorePlanBinding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRestoreChannel(String restoreChannel) {
            this.restoreChannel = restoreChannel;
            return this;
        }

        public Builder setRestorePlanBinding(String restorePlanBinding) {
            this.restorePlanBinding = restorePlanBinding;
            return this;
        }

        private Builder(RestorePlanBindingName restorePlanBindingName) {
            this.project = restorePlanBindingName.project;
            this.location = restorePlanBindingName.location;
            this.restoreChannel = restorePlanBindingName.restoreChannel;
            this.restorePlanBinding = restorePlanBindingName.restorePlanBinding;
        }

        public RestorePlanBindingName build() {
            return new RestorePlanBindingName(this);
        }
    }
}

