/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESTORE_PLAN_RESTORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String restorePlan;
    private final String restore;

    @Deprecated
    protected RestoreName() {
        this.project = null;
        this.location = null;
        this.restorePlan = null;
        this.restore = null;
    }

    private RestoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.restorePlan = (String)Preconditions.checkNotNull((Object)builder.getRestorePlan());
        this.restore = (String)Preconditions.checkNotNull((Object)builder.getRestore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRestorePlan() {
        return this.restorePlan;
    }

    public String getRestore() {
        return this.restore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RestoreName of(String project, String location, String restorePlan, String restore) {
        return RestoreName.newBuilder().setProject(project).setLocation(location).setRestorePlan(restorePlan).setRestore(restore).build();
    }

    public static String format(String project, String location, String restorePlan, String restore) {
        return RestoreName.newBuilder().setProject(project).setLocation(location).setRestorePlan(restorePlan).setRestore(restore).build().toString();
    }

    public static RestoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESTORE_PLAN_RESTORE.validatedMatch(formattedString, "RestoreName.parse: formattedString not in valid format");
        return RestoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("restore_plan"), (String)matchMap.get("restore"));
    }

    public static List<RestoreName> parseList(List<String> formattedStrings) {
        ArrayList<RestoreName> list = new ArrayList<RestoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RestoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RestoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RestoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESTORE_PLAN_RESTORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RestoreName restoreName = this;
            synchronized (restoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.restorePlan != null) {
                        fieldMapBuilder.put((Object)"restore_plan", (Object)this.restorePlan);
                    }
                    if (this.restore != null) {
                        fieldMapBuilder.put((Object)"restore", (Object)this.restore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESTORE_PLAN_RESTORE.instantiate(new String[]{"project", this.project, "location", this.location, "restore_plan", this.restorePlan, "restore", this.restore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RestoreName that = (RestoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.restorePlan, that.restorePlan) && Objects.equals(this.restore, that.restore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.restorePlan);
        h *= 1000003;
        return h ^= Objects.hashCode(this.restore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String restorePlan;
        private String restore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRestorePlan() {
            return this.restorePlan;
        }

        public String getRestore() {
            return this.restore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRestorePlan(String restorePlan) {
            this.restorePlan = restorePlan;
            return this;
        }

        public Builder setRestore(String restore) {
            this.restore = restore;
            return this;
        }

        private Builder(RestoreName restoreName) {
            this.project = restoreName.project;
            this.location = restoreName.location;
            this.restorePlan = restoreName.restorePlan;
            this.restore = restoreName.restore;
        }

        public RestoreName build() {
            return new RestoreName(this);
        }
    }
}

