/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestoreChannelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESTORE_CHANNEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/restoreChannels/{restore_channel}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String restoreChannel;

    @Deprecated
    protected RestoreChannelName() {
        this.project = null;
        this.location = null;
        this.restoreChannel = null;
    }

    private RestoreChannelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.restoreChannel = (String)Preconditions.checkNotNull((Object)builder.getRestoreChannel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRestoreChannel() {
        return this.restoreChannel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RestoreChannelName of(String project, String location, String restoreChannel) {
        return RestoreChannelName.newBuilder().setProject(project).setLocation(location).setRestoreChannel(restoreChannel).build();
    }

    public static String format(String project, String location, String restoreChannel) {
        return RestoreChannelName.newBuilder().setProject(project).setLocation(location).setRestoreChannel(restoreChannel).build().toString();
    }

    public static RestoreChannelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESTORE_CHANNEL.validatedMatch(formattedString, "RestoreChannelName.parse: formattedString not in valid format");
        return RestoreChannelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("restore_channel"));
    }

    public static List<RestoreChannelName> parseList(List<String> formattedStrings) {
        ArrayList<RestoreChannelName> list = new ArrayList<RestoreChannelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RestoreChannelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RestoreChannelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RestoreChannelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESTORE_CHANNEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RestoreChannelName restoreChannelName = this;
            synchronized (restoreChannelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.restoreChannel != null) {
                        fieldMapBuilder.put((Object)"restore_channel", (Object)this.restoreChannel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESTORE_CHANNEL.instantiate(new String[]{"project", this.project, "location", this.location, "restore_channel", this.restoreChannel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RestoreChannelName that = (RestoreChannelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.restoreChannel, that.restoreChannel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.restoreChannel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String restoreChannel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRestoreChannel() {
            return this.restoreChannel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRestoreChannel(String restoreChannel) {
            this.restoreChannel = restoreChannel;
            return this;
        }

        private Builder(RestoreChannelName restoreChannelName) {
            this.project = restoreChannelName.project;
            this.location = restoreChannelName.location;
            this.restoreChannel = restoreChannelName.restoreChannel;
        }

        public RestoreChannelName build() {
            return new RestoreChannelName(this);
        }
    }
}

