/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupPlanName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_PLAN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupPlans/{backup_plan}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupPlan;

    @Deprecated
    protected BackupPlanName() {
        this.project = null;
        this.location = null;
        this.backupPlan = null;
    }

    private BackupPlanName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupPlan = (String)Preconditions.checkNotNull((Object)builder.getBackupPlan());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupPlan() {
        return this.backupPlan;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupPlanName of(String project, String location, String backupPlan) {
        return BackupPlanName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).build();
    }

    public static String format(String project, String location, String backupPlan) {
        return BackupPlanName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).build().toString();
    }

    public static BackupPlanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_PLAN.validatedMatch(formattedString, "BackupPlanName.parse: formattedString not in valid format");
        return BackupPlanName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_plan"));
    }

    public static List<BackupPlanName> parseList(List<String> formattedStrings) {
        ArrayList<BackupPlanName> list = new ArrayList<BackupPlanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupPlanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupPlanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupPlanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_PLAN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupPlanName backupPlanName = this;
            synchronized (backupPlanName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupPlan != null) {
                        fieldMapBuilder.put((Object)"backup_plan", (Object)this.backupPlan);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_PLAN.instantiate(new String[]{"project", this.project, "location", this.location, "backup_plan", this.backupPlan});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupPlanName that = (BackupPlanName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupPlan, that.backupPlan);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupPlan);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupPlan;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupPlan() {
            return this.backupPlan;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupPlan(String backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        private Builder(BackupPlanName backupPlanName) {
            this.project = backupPlanName.project;
            this.location = backupPlanName.location;
            this.backupPlan = backupPlanName.backupPlan;
        }

        public BackupPlanName build() {
            return new BackupPlanName(this);
        }
    }
}

