/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupPlanBindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_CHANNEL_BACKUP_PLAN_BINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupChannels/{backup_channel}/backupPlanBindings/{backup_plan_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupChannel;
    private final String backupPlanBinding;

    @Deprecated
    protected BackupPlanBindingName() {
        this.project = null;
        this.location = null;
        this.backupChannel = null;
        this.backupPlanBinding = null;
    }

    private BackupPlanBindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupChannel = (String)Preconditions.checkNotNull((Object)builder.getBackupChannel());
        this.backupPlanBinding = (String)Preconditions.checkNotNull((Object)builder.getBackupPlanBinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupChannel() {
        return this.backupChannel;
    }

    public String getBackupPlanBinding() {
        return this.backupPlanBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupPlanBindingName of(String project, String location, String backupChannel, String backupPlanBinding) {
        return BackupPlanBindingName.newBuilder().setProject(project).setLocation(location).setBackupChannel(backupChannel).setBackupPlanBinding(backupPlanBinding).build();
    }

    public static String format(String project, String location, String backupChannel, String backupPlanBinding) {
        return BackupPlanBindingName.newBuilder().setProject(project).setLocation(location).setBackupChannel(backupChannel).setBackupPlanBinding(backupPlanBinding).build().toString();
    }

    public static BackupPlanBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_CHANNEL_BACKUP_PLAN_BINDING.validatedMatch(formattedString, "BackupPlanBindingName.parse: formattedString not in valid format");
        return BackupPlanBindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_channel"), (String)matchMap.get("backup_plan_binding"));
    }

    public static List<BackupPlanBindingName> parseList(List<String> formattedStrings) {
        ArrayList<BackupPlanBindingName> list = new ArrayList<BackupPlanBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupPlanBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupPlanBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupPlanBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_CHANNEL_BACKUP_PLAN_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupPlanBindingName backupPlanBindingName = this;
            synchronized (backupPlanBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupChannel != null) {
                        fieldMapBuilder.put((Object)"backup_channel", (Object)this.backupChannel);
                    }
                    if (this.backupPlanBinding != null) {
                        fieldMapBuilder.put((Object)"backup_plan_binding", (Object)this.backupPlanBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_CHANNEL_BACKUP_PLAN_BINDING.instantiate(new String[]{"project", this.project, "location", this.location, "backup_channel", this.backupChannel, "backup_plan_binding", this.backupPlanBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupPlanBindingName that = (BackupPlanBindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupChannel, that.backupChannel) && Objects.equals(this.backupPlanBinding, that.backupPlanBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.backupChannel);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupPlanBinding);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupChannel;
        private String backupPlanBinding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupChannel() {
            return this.backupChannel;
        }

        public String getBackupPlanBinding() {
            return this.backupPlanBinding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupChannel(String backupChannel) {
            this.backupChannel = backupChannel;
            return this;
        }

        public Builder setBackupPlanBinding(String backupPlanBinding) {
            this.backupPlanBinding = backupPlanBinding;
            return this;
        }

        private Builder(BackupPlanBindingName backupPlanBindingName) {
            this.project = backupPlanBindingName.project;
            this.location = backupPlanBindingName.location;
            this.backupChannel = backupPlanBindingName.backupChannel;
            this.backupPlanBinding = backupPlanBindingName.backupPlanBinding;
        }

        public BackupPlanBindingName build() {
            return new BackupPlanBindingName(this);
        }
    }
}

