/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupChannelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_CHANNEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupChannels/{backup_channel}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupChannel;

    @Deprecated
    protected BackupChannelName() {
        this.project = null;
        this.location = null;
        this.backupChannel = null;
    }

    private BackupChannelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupChannel = (String)Preconditions.checkNotNull((Object)builder.getBackupChannel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupChannel() {
        return this.backupChannel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupChannelName of(String project, String location, String backupChannel) {
        return BackupChannelName.newBuilder().setProject(project).setLocation(location).setBackupChannel(backupChannel).build();
    }

    public static String format(String project, String location, String backupChannel) {
        return BackupChannelName.newBuilder().setProject(project).setLocation(location).setBackupChannel(backupChannel).build().toString();
    }

    public static BackupChannelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_CHANNEL.validatedMatch(formattedString, "BackupChannelName.parse: formattedString not in valid format");
        return BackupChannelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_channel"));
    }

    public static List<BackupChannelName> parseList(List<String> formattedStrings) {
        ArrayList<BackupChannelName> list = new ArrayList<BackupChannelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupChannelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupChannelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupChannelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_CHANNEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupChannelName backupChannelName = this;
            synchronized (backupChannelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupChannel != null) {
                        fieldMapBuilder.put((Object)"backup_channel", (Object)this.backupChannel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_CHANNEL.instantiate(new String[]{"project", this.project, "location", this.location, "backup_channel", this.backupChannel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupChannelName that = (BackupChannelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupChannel, that.backupChannel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupChannel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupChannel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupChannel() {
            return this.backupChannel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupChannel(String backupChannel) {
            this.backupChannel = backupChannel;
            return this;
        }

        private Builder(BackupChannelName backupChannelName) {
            this.project = backupChannelName.project;
            this.location = backupChannelName.location;
            this.backupChannel = backupChannelName.backupChannel;
        }

        public BackupChannelName build() {
            return new BackupChannelName(this);
        }
    }
}

