/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VolumeRestoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESTORE_PLAN_RESTORE_VOLUME_RESTORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/restorePlans/{restore_plan}/restores/{restore}/volumeRestores/{volume_restore}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String restorePlan;
    private final String restore;
    private final String volumeRestore;

    @Deprecated
    protected VolumeRestoreName() {
        this.project = null;
        this.location = null;
        this.restorePlan = null;
        this.restore = null;
        this.volumeRestore = null;
    }

    private VolumeRestoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.restorePlan = (String)Preconditions.checkNotNull((Object)builder.getRestorePlan());
        this.restore = (String)Preconditions.checkNotNull((Object)builder.getRestore());
        this.volumeRestore = (String)Preconditions.checkNotNull((Object)builder.getVolumeRestore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRestorePlan() {
        return this.restorePlan;
    }

    public String getRestore() {
        return this.restore;
    }

    public String getVolumeRestore() {
        return this.volumeRestore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VolumeRestoreName of(String project, String location, String restorePlan, String restore, String volumeRestore) {
        return VolumeRestoreName.newBuilder().setProject(project).setLocation(location).setRestorePlan(restorePlan).setRestore(restore).setVolumeRestore(volumeRestore).build();
    }

    public static String format(String project, String location, String restorePlan, String restore, String volumeRestore) {
        return VolumeRestoreName.newBuilder().setProject(project).setLocation(location).setRestorePlan(restorePlan).setRestore(restore).setVolumeRestore(volumeRestore).build().toString();
    }

    public static VolumeRestoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESTORE_PLAN_RESTORE_VOLUME_RESTORE.validatedMatch(formattedString, "VolumeRestoreName.parse: formattedString not in valid format");
        return VolumeRestoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("restore_plan"), (String)matchMap.get("restore"), (String)matchMap.get("volume_restore"));
    }

    public static List<VolumeRestoreName> parseList(List<String> formattedStrings) {
        ArrayList<VolumeRestoreName> list = new ArrayList<VolumeRestoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VolumeRestoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VolumeRestoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VolumeRestoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESTORE_PLAN_RESTORE_VOLUME_RESTORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VolumeRestoreName volumeRestoreName = this;
            synchronized (volumeRestoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.restorePlan != null) {
                        fieldMapBuilder.put((Object)"restore_plan", (Object)this.restorePlan);
                    }
                    if (this.restore != null) {
                        fieldMapBuilder.put((Object)"restore", (Object)this.restore);
                    }
                    if (this.volumeRestore != null) {
                        fieldMapBuilder.put((Object)"volume_restore", (Object)this.volumeRestore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESTORE_PLAN_RESTORE_VOLUME_RESTORE.instantiate(new String[]{"project", this.project, "location", this.location, "restore_plan", this.restorePlan, "restore", this.restore, "volume_restore", this.volumeRestore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VolumeRestoreName that = (VolumeRestoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.restorePlan, that.restorePlan) && Objects.equals(this.restore, that.restore) && Objects.equals(this.volumeRestore, that.volumeRestore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.restorePlan);
        h *= 1000003;
        h ^= Objects.hashCode(this.restore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.volumeRestore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String restorePlan;
        private String restore;
        private String volumeRestore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRestorePlan() {
            return this.restorePlan;
        }

        public String getRestore() {
            return this.restore;
        }

        public String getVolumeRestore() {
            return this.volumeRestore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRestorePlan(String restorePlan) {
            this.restorePlan = restorePlan;
            return this;
        }

        public Builder setRestore(String restore) {
            this.restore = restore;
            return this;
        }

        public Builder setVolumeRestore(String volumeRestore) {
            this.volumeRestore = volumeRestore;
            return this;
        }

        private Builder(VolumeRestoreName volumeRestoreName) {
            this.project = volumeRestoreName.project;
            this.location = volumeRestoreName.location;
            this.restorePlan = volumeRestoreName.restorePlan;
            this.restore = volumeRestoreName.restore;
            this.volumeRestore = volumeRestoreName.volumeRestore;
        }

        public VolumeRestoreName build() {
            return new VolumeRestoreName(this);
        }
    }
}

