/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.geminidataanalytics.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataAgentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_AGENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataAgents/{data_agent}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataAgent;

    @Deprecated
    protected DataAgentName() {
        this.project = null;
        this.location = null;
        this.dataAgent = null;
    }

    private DataAgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataAgent = (String)Preconditions.checkNotNull((Object)builder.getDataAgent());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataAgent() {
        return this.dataAgent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataAgentName of(String project, String location, String dataAgent) {
        return DataAgentName.newBuilder().setProject(project).setLocation(location).setDataAgent(dataAgent).build();
    }

    public static String format(String project, String location, String dataAgent) {
        return DataAgentName.newBuilder().setProject(project).setLocation(location).setDataAgent(dataAgent).build().toString();
    }

    public static DataAgentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_AGENT.validatedMatch(formattedString, "DataAgentName.parse: formattedString not in valid format");
        return DataAgentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_agent"));
    }

    public static List<DataAgentName> parseList(List<String> formattedStrings) {
        ArrayList<DataAgentName> list = new ArrayList<DataAgentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataAgentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataAgentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataAgentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_AGENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataAgentName dataAgentName = this;
            synchronized (dataAgentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataAgent != null) {
                        fieldMapBuilder.put((Object)"data_agent", (Object)this.dataAgent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_AGENT.instantiate(new String[]{"project", this.project, "location", this.location, "data_agent", this.dataAgent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataAgentName that = (DataAgentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataAgent, that.dataAgent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataAgent);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataAgent;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataAgent() {
            return this.dataAgent;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataAgent(String dataAgent) {
            this.dataAgent = dataAgent;
            return this;
        }

        private Builder(DataAgentName dataAgentName) {
            this.project = dataAgentName.project;
            this.location = dataAgentName.location;
            this.dataAgent = dataAgentName.dataAgent;
        }

        public DataAgentName build() {
            return new DataAgentName(this);
        }
    }
}

