/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SiteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SITE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sites/{site}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String site;

    @Deprecated
    protected SiteName() {
        this.project = null;
        this.location = null;
        this.site = null;
    }

    private SiteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.site = (String)Preconditions.checkNotNull((Object)builder.getSite());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSite() {
        return this.site;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SiteName of(String project, String location, String site) {
        return SiteName.newBuilder().setProject(project).setLocation(location).setSite(site).build();
    }

    public static String format(String project, String location, String site) {
        return SiteName.newBuilder().setProject(project).setLocation(location).setSite(site).build().toString();
    }

    public static SiteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SITE.validatedMatch(formattedString, "SiteName.parse: formattedString not in valid format");
        return SiteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("site"));
    }

    public static List<SiteName> parseList(List<String> formattedStrings) {
        ArrayList<SiteName> list = new ArrayList<SiteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SiteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SiteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SiteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SITE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SiteName siteName = this;
            synchronized (siteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.site != null) {
                        fieldMapBuilder.put((Object)"site", (Object)this.site);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SITE.instantiate(new String[]{"project", this.project, "location", this.location, "site", this.site});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SiteName that = (SiteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.site, that.site);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.site);
    }

    public static class Builder {
        private String project;
        private String location;
        private String site;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSite() {
            return this.site;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSite(String site) {
            this.site = site;
            return this;
        }

        private Builder(SiteName siteName) {
            this.project = siteName.project;
            this.location = siteName.location;
            this.site = siteName.site;
        }

        public SiteName build() {
            return new SiteName(this);
        }
    }
}

