/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SkuName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SKU = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/skus/{sku}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String sku;

    @Deprecated
    protected SkuName() {
        this.project = null;
        this.location = null;
        this.sku = null;
    }

    private SkuName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.sku = (String)Preconditions.checkNotNull((Object)builder.getSku());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSku() {
        return this.sku;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SkuName of(String project, String location, String sku) {
        return SkuName.newBuilder().setProject(project).setLocation(location).setSku(sku).build();
    }

    public static String format(String project, String location, String sku) {
        return SkuName.newBuilder().setProject(project).setLocation(location).setSku(sku).build().toString();
    }

    public static SkuName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SKU.validatedMatch(formattedString, "SkuName.parse: formattedString not in valid format");
        return SkuName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("sku"));
    }

    public static List<SkuName> parseList(List<String> formattedStrings) {
        ArrayList<SkuName> list = new ArrayList<SkuName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SkuName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SkuName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SkuName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SKU.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SkuName skuName = this;
            synchronized (skuName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.sku != null) {
                        fieldMapBuilder.put((Object)"sku", (Object)this.sku);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SKU.instantiate(new String[]{"project", this.project, "location", this.location, "sku", this.sku});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SkuName that = (SkuName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.sku, that.sku);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sku);
    }

    public static class Builder {
        private String project;
        private String location;
        private String sku;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSku() {
            return this.sku;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSku(String sku) {
            this.sku = sku;
            return this;
        }

        private Builder(SkuName skuName) {
            this.project = skuName.project;
            this.location = skuName.location;
            this.sku = skuName.sku;
        }

        public SkuName build() {
            return new SkuName(this);
        }
    }
}

