/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HardwareName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_HARDWARE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/hardware/{hardware}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String hardware;

    @Deprecated
    protected HardwareName() {
        this.project = null;
        this.location = null;
        this.hardware = null;
    }

    private HardwareName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.hardware = (String)Preconditions.checkNotNull((Object)builder.getHardware());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHardware() {
        return this.hardware;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HardwareName of(String project, String location, String hardware) {
        return HardwareName.newBuilder().setProject(project).setLocation(location).setHardware(hardware).build();
    }

    public static String format(String project, String location, String hardware) {
        return HardwareName.newBuilder().setProject(project).setLocation(location).setHardware(hardware).build().toString();
    }

    public static HardwareName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_HARDWARE.validatedMatch(formattedString, "HardwareName.parse: formattedString not in valid format");
        return HardwareName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("hardware"));
    }

    public static List<HardwareName> parseList(List<String> formattedStrings) {
        ArrayList<HardwareName> list = new ArrayList<HardwareName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HardwareName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HardwareName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HardwareName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_HARDWARE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HardwareName hardwareName = this;
            synchronized (hardwareName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.hardware != null) {
                        fieldMapBuilder.put((Object)"hardware", (Object)this.hardware);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_HARDWARE.instantiate(new String[]{"project", this.project, "location", this.location, "hardware", this.hardware});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HardwareName that = (HardwareName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.hardware, that.hardware);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hardware);
    }

    public static class Builder {
        private String project;
        private String location;
        private String hardware;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getHardware() {
            return this.hardware;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setHardware(String hardware) {
            this.hardware = hardware;
            return this;
        }

        private Builder(HardwareName hardwareName) {
            this.project = hardwareName.project;
            this.location = hardwareName.location;
            this.hardware = hardwareName.hardware;
        }

        public HardwareName build() {
            return new HardwareName(this);
        }
    }
}

