/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HardwareGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORDER_HARDWARE_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orders/{order}/hardwareGroups/{hardware_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String order;
    private final String hardwareGroup;

    @Deprecated
    protected HardwareGroupName() {
        this.project = null;
        this.location = null;
        this.order = null;
        this.hardwareGroup = null;
    }

    private HardwareGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
        this.hardwareGroup = (String)Preconditions.checkNotNull((Object)builder.getHardwareGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrder() {
        return this.order;
    }

    public String getHardwareGroup() {
        return this.hardwareGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HardwareGroupName of(String project, String location, String order, String hardwareGroup) {
        return HardwareGroupName.newBuilder().setProject(project).setLocation(location).setOrder(order).setHardwareGroup(hardwareGroup).build();
    }

    public static String format(String project, String location, String order, String hardwareGroup) {
        return HardwareGroupName.newBuilder().setProject(project).setLocation(location).setOrder(order).setHardwareGroup(hardwareGroup).build().toString();
    }

    public static HardwareGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORDER_HARDWARE_GROUP.validatedMatch(formattedString, "HardwareGroupName.parse: formattedString not in valid format");
        return HardwareGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("order"), (String)matchMap.get("hardware_group"));
    }

    public static List<HardwareGroupName> parseList(List<String> formattedStrings) {
        ArrayList<HardwareGroupName> list = new ArrayList<HardwareGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HardwareGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HardwareGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HardwareGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORDER_HARDWARE_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HardwareGroupName hardwareGroupName = this;
            synchronized (hardwareGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    if (this.hardwareGroup != null) {
                        fieldMapBuilder.put((Object)"hardware_group", (Object)this.hardwareGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORDER_HARDWARE_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "order", this.order, "hardware_group", this.hardwareGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HardwareGroupName that = (HardwareGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.order, that.order) && Objects.equals(this.hardwareGroup, that.hardwareGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.order);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hardwareGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String order;
        private String hardwareGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrder() {
            return this.order;
        }

        public String getHardwareGroup() {
            return this.hardwareGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        public Builder setHardwareGroup(String hardwareGroup) {
            this.hardwareGroup = hardwareGroup;
            return this;
        }

        private Builder(HardwareGroupName hardwareGroupName) {
            this.project = hardwareGroupName.project;
            this.location = hardwareGroupName.location;
            this.order = hardwareGroupName.order;
            this.hardwareGroup = hardwareGroupName.hardwareGroup;
        }

        public HardwareGroupName build() {
            return new HardwareGroupName(this);
        }
    }
}

