/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orders/{order}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String order;

    @Deprecated
    protected OrderName() {
        this.project = null;
        this.location = null;
        this.order = null;
    }

    private OrderName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrder() {
        return this.order;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrderName of(String project, String location, String order) {
        return OrderName.newBuilder().setProject(project).setLocation(location).setOrder(order).build();
    }

    public static String format(String project, String location, String order) {
        return OrderName.newBuilder().setProject(project).setLocation(location).setOrder(order).build().toString();
    }

    public static OrderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORDER.validatedMatch(formattedString, "OrderName.parse: formattedString not in valid format");
        return OrderName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("order"));
    }

    public static List<OrderName> parseList(List<String> formattedStrings) {
        ArrayList<OrderName> list = new ArrayList<OrderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrderName orderName = this;
            synchronized (orderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORDER.instantiate(new String[]{"project", this.project, "location", this.location, "order", this.order});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrderName that = (OrderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.order, that.order);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.order);
    }

    public static class Builder {
        private String project;
        private String location;
        private String order;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrder() {
            return this.order;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        private Builder(OrderName orderName) {
            this.project = orderName.project;
            this.location = orderName.location;
            this.order = orderName.order;
        }

        public OrderName build() {
            return new OrderName(this);
        }
    }
}

