/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CommentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORDER_COMMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orders/{order}/comments/{comment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String order;
    private final String comment;

    @Deprecated
    protected CommentName() {
        this.project = null;
        this.location = null;
        this.order = null;
        this.comment = null;
    }

    private CommentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
        this.comment = (String)Preconditions.checkNotNull((Object)builder.getComment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrder() {
        return this.order;
    }

    public String getComment() {
        return this.comment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CommentName of(String project, String location, String order, String comment) {
        return CommentName.newBuilder().setProject(project).setLocation(location).setOrder(order).setComment(comment).build();
    }

    public static String format(String project, String location, String order, String comment) {
        return CommentName.newBuilder().setProject(project).setLocation(location).setOrder(order).setComment(comment).build().toString();
    }

    public static CommentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORDER_COMMENT.validatedMatch(formattedString, "CommentName.parse: formattedString not in valid format");
        return CommentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("order"), (String)matchMap.get("comment"));
    }

    public static List<CommentName> parseList(List<String> formattedStrings) {
        ArrayList<CommentName> list = new ArrayList<CommentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CommentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CommentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CommentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORDER_COMMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CommentName commentName = this;
            synchronized (commentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    if (this.comment != null) {
                        fieldMapBuilder.put((Object)"comment", (Object)this.comment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORDER_COMMENT.instantiate(new String[]{"project", this.project, "location", this.location, "order", this.order, "comment", this.comment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CommentName that = (CommentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.order, that.order) && Objects.equals(this.comment, that.comment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.order);
        h *= 1000003;
        return h ^= Objects.hashCode(this.comment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String order;
        private String comment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrder() {
            return this.order;
        }

        public String getComment() {
            return this.comment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        private Builder(CommentName commentName) {
            this.project = commentName.project;
            this.location = commentName.location;
            this.order = commentName.order;
            this.comment = commentName.comment;
        }

        public CommentName build() {
            return new CommentName(this);
        }
    }
}

