/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChangeLogEntryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORDER_CHANGE_LOG_ENTRY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orders/{order}/changeLogEntries/{change_log_entry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String order;
    private final String changeLogEntry;

    @Deprecated
    protected ChangeLogEntryName() {
        this.project = null;
        this.location = null;
        this.order = null;
        this.changeLogEntry = null;
    }

    private ChangeLogEntryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.order = (String)Preconditions.checkNotNull((Object)builder.getOrder());
        this.changeLogEntry = (String)Preconditions.checkNotNull((Object)builder.getChangeLogEntry());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrder() {
        return this.order;
    }

    public String getChangeLogEntry() {
        return this.changeLogEntry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChangeLogEntryName of(String project, String location, String order, String changeLogEntry) {
        return ChangeLogEntryName.newBuilder().setProject(project).setLocation(location).setOrder(order).setChangeLogEntry(changeLogEntry).build();
    }

    public static String format(String project, String location, String order, String changeLogEntry) {
        return ChangeLogEntryName.newBuilder().setProject(project).setLocation(location).setOrder(order).setChangeLogEntry(changeLogEntry).build().toString();
    }

    public static ChangeLogEntryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORDER_CHANGE_LOG_ENTRY.validatedMatch(formattedString, "ChangeLogEntryName.parse: formattedString not in valid format");
        return ChangeLogEntryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("order"), (String)matchMap.get("change_log_entry"));
    }

    public static List<ChangeLogEntryName> parseList(List<String> formattedStrings) {
        ArrayList<ChangeLogEntryName> list = new ArrayList<ChangeLogEntryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChangeLogEntryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChangeLogEntryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChangeLogEntryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORDER_CHANGE_LOG_ENTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChangeLogEntryName changeLogEntryName = this;
            synchronized (changeLogEntryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.order != null) {
                        fieldMapBuilder.put((Object)"order", (Object)this.order);
                    }
                    if (this.changeLogEntry != null) {
                        fieldMapBuilder.put((Object)"change_log_entry", (Object)this.changeLogEntry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORDER_CHANGE_LOG_ENTRY.instantiate(new String[]{"project", this.project, "location", this.location, "order", this.order, "change_log_entry", this.changeLogEntry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChangeLogEntryName that = (ChangeLogEntryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.order, that.order) && Objects.equals(this.changeLogEntry, that.changeLogEntry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.order);
        h *= 1000003;
        return h ^= Objects.hashCode(this.changeLogEntry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String order;
        private String changeLogEntry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrder() {
            return this.order;
        }

        public String getChangeLogEntry() {
            return this.changeLogEntry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrder(String order) {
            this.order = order;
            return this;
        }

        public Builder setChangeLogEntry(String changeLogEntry) {
            this.changeLogEntry = changeLogEntry;
            return this;
        }

        private Builder(ChangeLogEntryName changeLogEntryName) {
            this.project = changeLogEntryName.project;
            this.location = changeLogEntryName.location;
            this.order = changeLogEntryName.order;
            this.changeLogEntry = changeLogEntryName.changeLogEntry;
        }

        public ChangeLogEntryName build() {
            return new ChangeLogEntryName(this);
        }
    }
}

