/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2alpha/functions.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.functions.v2alpha;

/**
 *
 *
 * <pre>
 * Configuration for a secret volume. It has the information necessary to fetch
 * the secret value from secret manager and make it available as files mounted
 * at the requested paths within the application container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2alpha.SecretVolume}
 */
public final class SecretVolume extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.SecretVolume)
    SecretVolumeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SecretVolume.newBuilder() to construct.
  private SecretVolume(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SecretVolume() {
    mountPath_ = "";
    projectId_ = "";
    secret_ = "";
    versions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SecretVolume();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_SecretVolume_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_SecretVolume_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2alpha.SecretVolume.class,
            com.google.cloud.functions.v2alpha.SecretVolume.Builder.class);
  }

  public interface SecretVersionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.functions.v2alpha.SecretVolume.SecretVersion)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Version of the secret (version number or the string 'latest'). It is
     * preferable to use `latest` version with secret volumes as secret value
     * changes are reflected immediately.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    java.lang.String getVersion();
    /**
     *
     *
     * <pre>
     * Version of the secret (version number or the string 'latest'). It is
     * preferable to use `latest` version with secret volumes as secret value
     * changes are reflected immediately.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    com.google.protobuf.ByteString getVersionBytes();

    /**
     *
     *
     * <pre>
     * Relative path of the file under the mount path where the secret value for
     * this version will be fetched and made available. For example, setting the
     * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
     * secret value file at `/etc/secrets/secret_foo`.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Relative path of the file under the mount path where the secret value for
     * this version will be fetched and made available. For example, setting the
     * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
     * secret value file at `/etc/secrets/secret_foo`.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a single version.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.SecretVolume.SecretVersion}
   */
  public static final class SecretVersion extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.SecretVolume.SecretVersion)
      SecretVersionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SecretVersion.newBuilder() to construct.
    private SecretVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SecretVersion() {
      version_ = "";
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SecretVersion();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_SecretVolume_SecretVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_SecretVolume_SecretVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.class,
              com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder.class);
    }

    public static final int VERSION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Version of the secret (version number or the string 'latest'). It is
     * preferable to use `latest` version with secret volumes as secret value
     * changes are reflected immediately.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    @java.lang.Override
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of the secret (version number or the string 'latest'). It is
     * preferable to use `latest` version with secret volumes as secret value
     * changes are reflected immediately.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * Relative path of the file under the mount path where the secret value for
     * this version will be fetched and made available. For example, setting the
     * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
     * secret value file at `/etc/secrets/secret_foo`.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Relative path of the file under the mount path where the secret value for
     * this version will be fetched and made available. For example, setting the
     * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
     * secret value file at `/etc/secrets/secret_foo`.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion)) {
        return super.equals(obj);
      }
      com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion other =
          (com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion) obj;

      if (!getVersion().equals(other.getVersion())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getVersion().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a single version.
     * </pre>
     *
     * Protobuf type {@code google.cloud.functions.v2alpha.SecretVolume.SecretVersion}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.SecretVolume.SecretVersion)
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_SecretVolume_SecretVersion_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_SecretVolume_SecretVersion_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.class,
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder.class);
      }

      // Construct using com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        version_ = "";
        path_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.functions.v2alpha.FunctionsProto
            .internal_static_google_cloud_functions_v2alpha_SecretVolume_SecretVersion_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion
          getDefaultInstanceForType() {
        return com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion build() {
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion buildPartial() {
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion result =
            new com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.version_ = version_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.path_ = path_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion) {
          return mergeFrom((com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion other) {
        if (other
            == com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.getDefaultInstance())
          return this;
        if (!other.getVersion().isEmpty()) {
          version_ = other.version_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  version_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object version_ = "";
      /**
       *
       *
       * <pre>
       * Version of the secret (version number or the string 'latest'). It is
       * preferable to use `latest` version with secret volumes as secret value
       * changes are reflected immediately.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The version.
       */
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Version of the secret (version number or the string 'latest'). It is
       * preferable to use `latest` version with secret volumes as secret value
       * changes are reflected immediately.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return The bytes for version.
       */
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Version of the secret (version number or the string 'latest'). It is
       * preferable to use `latest` version with secret volumes as secret value
       * changes are reflected immediately.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The version to set.
       * @return This builder for chaining.
       */
      public Builder setVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version of the secret (version number or the string 'latest'). It is
       * preferable to use `latest` version with secret volumes as secret value
       * changes are reflected immediately.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVersion() {
        version_ = getDefaultInstance().getVersion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version of the secret (version number or the string 'latest'). It is
       * preferable to use `latest` version with secret volumes as secret value
       * changes are reflected immediately.
       * </pre>
       *
       * <code>string version = 1;</code>
       *
       * @param value The bytes for version to set.
       * @return This builder for chaining.
       */
      public Builder setVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        version_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Relative path of the file under the mount path where the secret value for
       * this version will be fetched and made available. For example, setting the
       * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
       * secret value file at `/etc/secrets/secret_foo`.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Relative path of the file under the mount path where the secret value for
       * this version will be fetched and made available. For example, setting the
       * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
       * secret value file at `/etc/secrets/secret_foo`.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Relative path of the file under the mount path where the secret value for
       * this version will be fetched and made available. For example, setting the
       * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
       * secret value file at `/etc/secrets/secret_foo`.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Relative path of the file under the mount path where the secret value for
       * this version will be fetched and made available. For example, setting the
       * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
       * secret value file at `/etc/secrets/secret_foo`.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Relative path of the file under the mount path where the secret value for
       * this version will be fetched and made available. For example, setting the
       * mount_path as '/etc/secrets' and path as `secret_foo` would mount the
       * secret value file at `/etc/secrets/secret_foo`.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.SecretVolume.SecretVersion)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.SecretVolume.SecretVersion)
    private static final com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion();
    }

    public static com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SecretVersion> PARSER =
        new com.google.protobuf.AbstractParser<SecretVersion>() {
          @java.lang.Override
          public SecretVersion parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SecretVersion> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SecretVersion> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int MOUNT_PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mountPath_ = "";
  /**
   *
   *
   * <pre>
   * The path within the container to mount the secret volume. For example,
   * setting the mount_path as `/etc/secrets` would mount the secret value files
   * under the `/etc/secrets` directory. This directory will also be completely
   * shadowed and unavailable to mount any other secrets.
   * Recommended mount path: /etc/secrets
   * </pre>
   *
   * <code>string mount_path = 1;</code>
   *
   * @return The mountPath.
   */
  @java.lang.Override
  public java.lang.String getMountPath() {
    java.lang.Object ref = mountPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mountPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The path within the container to mount the secret volume. For example,
   * setting the mount_path as `/etc/secrets` would mount the secret value files
   * under the `/etc/secrets` directory. This directory will also be completely
   * shadowed and unavailable to mount any other secrets.
   * Recommended mount path: /etc/secrets
   * </pre>
   *
   * <code>string mount_path = 1;</code>
   *
   * @return The bytes for mountPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMountPathBytes() {
    java.lang.Object ref = mountPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mountPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * Project identifier (preferably project number but can also be the project
   * ID) of the project that contains the secret. If not set, it is
   * assumed that the secret is in the same project as the function.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project identifier (preferably project number but can also be the project
   * ID) of the project that contains the secret. If not set, it is
   * assumed that the secret is in the same project as the function.
   * </pre>
   *
   * <code>string project_id = 2;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SECRET_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object secret_ = "";
  /**
   *
   *
   * <pre>
   * Name of the secret in secret manager (not the full resource name).
   * </pre>
   *
   * <code>string secret = 3;</code>
   *
   * @return The secret.
   */
  @java.lang.Override
  public java.lang.String getSecret() {
    java.lang.Object ref = secret_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      secret_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the secret in secret manager (not the full resource name).
   * </pre>
   *
   * <code>string secret = 3;</code>
   *
   * @return The bytes for secret.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSecretBytes() {
    java.lang.Object ref = secret_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      secret_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion> versions_;
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion>
      getVersionsList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>
      getVersionsOrBuilderList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  @java.lang.Override
  public int getVersionsCount() {
    return versions_.size();
  }
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion getVersions(int index) {
    return versions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of secret versions to mount for this secret. If empty, the `latest`
   * version of the secret will be made available in a file named after the
   * secret under the mount point.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder
      getVersionsOrBuilder(int index) {
    return versions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mountPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secret_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, secret_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      output.writeMessage(4, versions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mountPath_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secret_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, secret_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, versions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2alpha.SecretVolume)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2alpha.SecretVolume other =
        (com.google.cloud.functions.v2alpha.SecretVolume) obj;

    if (!getMountPath().equals(other.getMountPath())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getSecret().equals(other.getSecret())) return false;
    if (!getVersionsList().equals(other.getVersionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MOUNT_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getMountPath().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + SECRET_FIELD_NUMBER;
    hash = (53 * hash) + getSecret().hashCode();
    if (getVersionsCount() > 0) {
      hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getVersionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2alpha.SecretVolume prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a secret volume. It has the information necessary to fetch
   * the secret value from secret manager and make it available as files mounted
   * at the requested paths within the application container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.SecretVolume}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.SecretVolume)
      com.google.cloud.functions.v2alpha.SecretVolumeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_SecretVolume_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_SecretVolume_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.SecretVolume.class,
              com.google.cloud.functions.v2alpha.SecretVolume.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2alpha.SecretVolume.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mountPath_ = "";
      projectId_ = "";
      secret_ = "";
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
      } else {
        versions_ = null;
        versionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_SecretVolume_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.SecretVolume getDefaultInstanceForType() {
      return com.google.cloud.functions.v2alpha.SecretVolume.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.SecretVolume build() {
      com.google.cloud.functions.v2alpha.SecretVolume result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.SecretVolume buildPartial() {
      com.google.cloud.functions.v2alpha.SecretVolume result =
          new com.google.cloud.functions.v2alpha.SecretVolume(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.functions.v2alpha.SecretVolume result) {
      if (versionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          versions_ = java.util.Collections.unmodifiableList(versions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.versions_ = versions_;
      } else {
        result.versions_ = versionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2alpha.SecretVolume result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mountPath_ = mountPath_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.secret_ = secret_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2alpha.SecretVolume) {
        return mergeFrom((com.google.cloud.functions.v2alpha.SecretVolume) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2alpha.SecretVolume other) {
      if (other == com.google.cloud.functions.v2alpha.SecretVolume.getDefaultInstance())
        return this;
      if (!other.getMountPath().isEmpty()) {
        mountPath_ = other.mountPath_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSecret().isEmpty()) {
        secret_ = other.secret_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (versionsBuilder_ == null) {
        if (!other.versions_.isEmpty()) {
          if (versions_.isEmpty()) {
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureVersionsIsMutable();
            versions_.addAll(other.versions_);
          }
          onChanged();
        }
      } else {
        if (!other.versions_.isEmpty()) {
          if (versionsBuilder_.isEmpty()) {
            versionsBuilder_.dispose();
            versionsBuilder_ = null;
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            versionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVersionsFieldBuilder()
                    : null;
          } else {
            versionsBuilder_.addAllMessages(other.versions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                mountPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                secret_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion m =
                    input.readMessage(
                        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.parser(),
                        extensionRegistry);
                if (versionsBuilder_ == null) {
                  ensureVersionsIsMutable();
                  versions_.add(m);
                } else {
                  versionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object mountPath_ = "";
    /**
     *
     *
     * <pre>
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` would mount the secret value files
     * under the `/etc/secrets` directory. This directory will also be completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount path: /etc/secrets
     * </pre>
     *
     * <code>string mount_path = 1;</code>
     *
     * @return The mountPath.
     */
    public java.lang.String getMountPath() {
      java.lang.Object ref = mountPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mountPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` would mount the secret value files
     * under the `/etc/secrets` directory. This directory will also be completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount path: /etc/secrets
     * </pre>
     *
     * <code>string mount_path = 1;</code>
     *
     * @return The bytes for mountPath.
     */
    public com.google.protobuf.ByteString getMountPathBytes() {
      java.lang.Object ref = mountPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mountPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` would mount the secret value files
     * under the `/etc/secrets` directory. This directory will also be completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount path: /etc/secrets
     * </pre>
     *
     * <code>string mount_path = 1;</code>
     *
     * @param value The mountPath to set.
     * @return This builder for chaining.
     */
    public Builder setMountPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mountPath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` would mount the secret value files
     * under the `/etc/secrets` directory. This directory will also be completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount path: /etc/secrets
     * </pre>
     *
     * <code>string mount_path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMountPath() {
      mountPath_ = getDefaultInstance().getMountPath();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The path within the container to mount the secret volume. For example,
     * setting the mount_path as `/etc/secrets` would mount the secret value files
     * under the `/etc/secrets` directory. This directory will also be completely
     * shadowed and unavailable to mount any other secrets.
     * Recommended mount path: /etc/secrets
     * </pre>
     *
     * <code>string mount_path = 1;</code>
     *
     * @param value The bytes for mountPath to set.
     * @return This builder for chaining.
     */
    public Builder setMountPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mountPath_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Project identifier (preferably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * assumed that the secret is in the same project as the function.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project identifier (preferably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * assumed that the secret is in the same project as the function.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project identifier (preferably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * assumed that the secret is in the same project as the function.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project identifier (preferably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * assumed that the secret is in the same project as the function.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project identifier (preferably project number but can also be the project
     * ID) of the project that contains the secret. If not set, it is
     * assumed that the secret is in the same project as the function.
     * </pre>
     *
     * <code>string project_id = 2;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object secret_ = "";
    /**
     *
     *
     * <pre>
     * Name of the secret in secret manager (not the full resource name).
     * </pre>
     *
     * <code>string secret = 3;</code>
     *
     * @return The secret.
     */
    public java.lang.String getSecret() {
      java.lang.Object ref = secret_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secret_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the secret in secret manager (not the full resource name).
     * </pre>
     *
     * <code>string secret = 3;</code>
     *
     * @return The bytes for secret.
     */
    public com.google.protobuf.ByteString getSecretBytes() {
      java.lang.Object ref = secret_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the secret in secret manager (not the full resource name).
     * </pre>
     *
     * <code>string secret = 3;</code>
     *
     * @param value The secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      secret_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the secret in secret manager (not the full resource name).
     * </pre>
     *
     * <code>string secret = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecret() {
      secret_ = getDefaultInstance().getSecret();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the secret in secret manager (not the full resource name).
     * </pre>
     *
     * <code>string secret = 3;</code>
     *
     * @param value The bytes for secret to set.
     * @return This builder for chaining.
     */
    public Builder setSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      secret_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion>
        versions_ = java.util.Collections.emptyList();

    private void ensureVersionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        versions_ =
            new java.util.ArrayList<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion>(
                versions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion,
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder,
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>
        versionsBuilder_;

    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion>
        getVersionsList() {
      if (versionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(versions_);
      } else {
        return versionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public int getVersionsCount() {
      if (versionsBuilder_ == null) {
        return versions_.size();
      } else {
        return versionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion getVersions(int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder setVersions(
        int index, com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.set(index, value);
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder setVersions(
        int index,
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.set(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder addVersions(
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder addVersions(
        int index, com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(index, value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder addVersions(
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder addVersions(
        int index,
        com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder addAllVersions(
        java.lang.Iterable<? extends com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion>
            values) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versions_);
        onChanged();
      } else {
        versionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder clearVersions() {
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        versionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public Builder removeVersions(int index) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.remove(index);
        onChanged();
      } else {
        versionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder getVersionsBuilder(
        int index) {
      return getVersionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder
        getVersionsOrBuilder(int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>
        getVersionsOrBuilderList() {
      if (versionsBuilder_ != null) {
        return versionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(versions_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder
        addVersionsBuilder() {
      return getVersionsFieldBuilder()
          .addBuilder(
              com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder addVersionsBuilder(
        int index) {
      return getVersionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secret versions to mount for this secret. If empty, the `latest`
     * version of the secret will be made available in a file named after the
     * secret under the mount point.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2alpha.SecretVolume.SecretVersion versions = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder>
        getVersionsBuilderList() {
      return getVersionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion,
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder,
            com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>
        getVersionsFieldBuilder() {
      if (versionsBuilder_ == null) {
        versionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion,
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersion.Builder,
                com.google.cloud.functions.v2alpha.SecretVolume.SecretVersionOrBuilder>(
                versions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        versions_ = null;
      }
      return versionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.SecretVolume)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.SecretVolume)
  private static final com.google.cloud.functions.v2alpha.SecretVolume DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.SecretVolume();
  }

  public static com.google.cloud.functions.v2alpha.SecretVolume getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SecretVolume> PARSER =
      new com.google.protobuf.AbstractParser<SecretVolume>() {
        @java.lang.Override
        public SecretVolume parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SecretVolume> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SecretVolume> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2alpha.SecretVolume getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
