/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2alpha/functions.proto

package com.google.cloud.functions.v2alpha;

/**
 *
 *
 * <pre>
 * Location of the source in a Google Cloud Source Repository.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2alpha.RepoSource}
 */
public final class RepoSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2alpha.RepoSource)
    RepoSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepoSource.newBuilder() to construct.
  private RepoSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepoSource() {
    projectId_ = "";
    repoName_ = "";
    dir_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepoSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_RepoSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2alpha.FunctionsProto
        .internal_static_google_cloud_functions_v2alpha_RepoSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2alpha.RepoSource.class,
            com.google.cloud.functions.v2alpha.RepoSource.Builder.class);
  }

  private int revisionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object revision_;

  public enum RevisionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BRANCH_NAME(3),
    TAG_NAME(4),
    COMMIT_SHA(5),
    REVISION_NOT_SET(0);
    private final int value;

    private RevisionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RevisionCase valueOf(int value) {
      return forNumber(value);
    }

    public static RevisionCase forNumber(int value) {
      switch (value) {
        case 3:
          return BRANCH_NAME;
        case 4:
          return TAG_NAME;
        case 5:
          return COMMIT_SHA;
        case 0:
          return REVISION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RevisionCase getRevisionCase() {
    return RevisionCase.forNumber(revisionCase_);
  }

  public static final int BRANCH_NAME_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Regex matching branches to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string branch_name = 3;</code>
   *
   * @return Whether the branchName field is set.
   */
  public boolean hasBranchName() {
    return revisionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Regex matching branches to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string branch_name = 3;</code>
   *
   * @return The branchName.
   */
  public java.lang.String getBranchName() {
    java.lang.Object ref = "";
    if (revisionCase_ == 3) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 3) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Regex matching branches to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string branch_name = 3;</code>
   *
   * @return The bytes for branchName.
   */
  public com.google.protobuf.ByteString getBranchNameBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 3) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 3) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_NAME_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Regex matching tags to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string tag_name = 4;</code>
   *
   * @return Whether the tagName field is set.
   */
  public boolean hasTagName() {
    return revisionCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Regex matching tags to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string tag_name = 4;</code>
   *
   * @return The tagName.
   */
  public java.lang.String getTagName() {
    java.lang.Object ref = "";
    if (revisionCase_ == 4) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 4) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Regex matching tags to build.
   *
   * The syntax of the regular expressions accepted is the syntax accepted by
   * RE2 and described at https://github.com/google/re2/wiki/Syntax
   * </pre>
   *
   * <code>string tag_name = 4;</code>
   *
   * @return The bytes for tagName.
   */
  public com.google.protobuf.ByteString getTagNameBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 4) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 4) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMIT_SHA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Explicit commit SHA to build.
   * </pre>
   *
   * <code>string commit_sha = 5;</code>
   *
   * @return Whether the commitSha field is set.
   */
  public boolean hasCommitSha() {
    return revisionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Explicit commit SHA to build.
   * </pre>
   *
   * <code>string commit_sha = 5;</code>
   *
   * @return The commitSha.
   */
  public java.lang.String getCommitSha() {
    java.lang.Object ref = "";
    if (revisionCase_ == 5) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (revisionCase_ == 5) {
        revision_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Explicit commit SHA to build.
   * </pre>
   *
   * <code>string commit_sha = 5;</code>
   *
   * @return The bytes for commitSha.
   */
  public com.google.protobuf.ByteString getCommitShaBytes() {
    java.lang.Object ref = "";
    if (revisionCase_ == 5) {
      ref = revision_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (revisionCase_ == 5) {
        revision_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * ID of the project that owns the Cloud Source Repository. If omitted, the
   * project ID requesting the build is assumed.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the project that owns the Cloud Source Repository. If omitted, the
   * project ID requesting the build is assumed.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPO_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object repoName_ = "";
  /**
   *
   *
   * <pre>
   * Name of the Cloud Source Repository.
   * </pre>
   *
   * <code>string repo_name = 2;</code>
   *
   * @return The repoName.
   */
  @java.lang.Override
  public java.lang.String getRepoName() {
    java.lang.Object ref = repoName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      repoName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the Cloud Source Repository.
   * </pre>
   *
   * <code>string repo_name = 2;</code>
   *
   * @return The bytes for repoName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRepoNameBytes() {
    java.lang.Object ref = repoName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      repoName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dir_ = "";
  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   *
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * eg. helloworld (no leading slash allowed)
   * </pre>
   *
   * <code>string dir = 6;</code>
   *
   * @return The dir.
   */
  @java.lang.Override
  public java.lang.String getDir() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dir_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Directory, relative to the source root, in which to run the build.
   *
   * This must be a relative path. If a step's `dir` is specified and is an
   * absolute path, this value is ignored for that step's execution.
   * eg. helloworld (no leading slash allowed)
   * </pre>
   *
   * <code>string dir = 6;</code>
   *
   * @return The bytes for dir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDirBytes() {
    java.lang.Object ref = dir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INVERT_REGEX_FIELD_NUMBER = 7;
  private boolean invertRegex_ = false;
  /**
   *
   *
   * <pre>
   * Only trigger a build if the revision regex does NOT match the revision
   * regex.
   * </pre>
   *
   * <code>bool invert_regex = 7;</code>
   *
   * @return The invertRegex.
   */
  @java.lang.Override
  public boolean getInvertRegex() {
    return invertRegex_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repoName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, repoName_);
    }
    if (revisionCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, revision_);
    }
    if (revisionCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, revision_);
    }
    if (revisionCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, revision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, dir_);
    }
    if (invertRegex_ != false) {
      output.writeBool(7, invertRegex_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(repoName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, repoName_);
    }
    if (revisionCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, revision_);
    }
    if (revisionCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, revision_);
    }
    if (revisionCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, revision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, dir_);
    }
    if (invertRegex_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, invertRegex_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2alpha.RepoSource)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2alpha.RepoSource other =
        (com.google.cloud.functions.v2alpha.RepoSource) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getRepoName().equals(other.getRepoName())) return false;
    if (!getDir().equals(other.getDir())) return false;
    if (getInvertRegex() != other.getInvertRegex()) return false;
    if (!getRevisionCase().equals(other.getRevisionCase())) return false;
    switch (revisionCase_) {
      case 3:
        if (!getBranchName().equals(other.getBranchName())) return false;
        break;
      case 4:
        if (!getTagName().equals(other.getTagName())) return false;
        break;
      case 5:
        if (!getCommitSha().equals(other.getCommitSha())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + REPO_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getRepoName().hashCode();
    hash = (37 * hash) + DIR_FIELD_NUMBER;
    hash = (53 * hash) + getDir().hashCode();
    hash = (37 * hash) + INVERT_REGEX_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInvertRegex());
    switch (revisionCase_) {
      case 3:
        hash = (37 * hash) + BRANCH_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getBranchName().hashCode();
        break;
      case 4:
        hash = (37 * hash) + TAG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getTagName().hashCode();
        break;
      case 5:
        hash = (37 * hash) + COMMIT_SHA_FIELD_NUMBER;
        hash = (53 * hash) + getCommitSha().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2alpha.RepoSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2alpha.RepoSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Location of the source in a Google Cloud Source Repository.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2alpha.RepoSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2alpha.RepoSource)
      com.google.cloud.functions.v2alpha.RepoSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_RepoSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_RepoSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2alpha.RepoSource.class,
              com.google.cloud.functions.v2alpha.RepoSource.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2alpha.RepoSource.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      repoName_ = "";
      dir_ = "";
      invertRegex_ = false;
      revisionCase_ = 0;
      revision_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2alpha.FunctionsProto
          .internal_static_google_cloud_functions_v2alpha_RepoSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.RepoSource getDefaultInstanceForType() {
      return com.google.cloud.functions.v2alpha.RepoSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.RepoSource build() {
      com.google.cloud.functions.v2alpha.RepoSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2alpha.RepoSource buildPartial() {
      com.google.cloud.functions.v2alpha.RepoSource result =
          new com.google.cloud.functions.v2alpha.RepoSource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.functions.v2alpha.RepoSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.repoName_ = repoName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dir_ = dir_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.invertRegex_ = invertRegex_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.functions.v2alpha.RepoSource result) {
      result.revisionCase_ = revisionCase_;
      result.revision_ = this.revision_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2alpha.RepoSource) {
        return mergeFrom((com.google.cloud.functions.v2alpha.RepoSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2alpha.RepoSource other) {
      if (other == com.google.cloud.functions.v2alpha.RepoSource.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRepoName().isEmpty()) {
        repoName_ = other.repoName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDir().isEmpty()) {
        dir_ = other.dir_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.getInvertRegex() != false) {
        setInvertRegex(other.getInvertRegex());
      }
      switch (other.getRevisionCase()) {
        case BRANCH_NAME:
          {
            revisionCase_ = 3;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case TAG_NAME:
          {
            revisionCase_ = 4;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case COMMIT_SHA:
          {
            revisionCase_ = 5;
            revision_ = other.revision_;
            onChanged();
            break;
          }
        case REVISION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                repoName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                revisionCase_ = 3;
                revision_ = s;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                revisionCase_ = 4;
                revision_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                revisionCase_ = 5;
                revision_ = s;
                break;
              } // case 42
            case 50:
              {
                dir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                invertRegex_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int revisionCase_ = 0;
    private java.lang.Object revision_;

    public RevisionCase getRevisionCase() {
      return RevisionCase.forNumber(revisionCase_);
    }

    public Builder clearRevision() {
      revisionCase_ = 0;
      revision_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return Whether the branchName field is set.
     */
    @java.lang.Override
    public boolean hasBranchName() {
      return revisionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return The branchName.
     */
    @java.lang.Override
    public java.lang.String getBranchName() {
      java.lang.Object ref = "";
      if (revisionCase_ == 3) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 3) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return The bytes for branchName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBranchNameBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 3) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 3) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @param value The branchName to set.
     * @return This builder for chaining.
     */
    public Builder setBranchName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 3;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBranchName() {
      if (revisionCase_ == 3) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching branches to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string branch_name = 3;</code>
     *
     * @param value The bytes for branchName to set.
     * @return This builder for chaining.
     */
    public Builder setBranchNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 3;
      revision_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return Whether the tagName field is set.
     */
    @java.lang.Override
    public boolean hasTagName() {
      return revisionCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return The tagName.
     */
    @java.lang.Override
    public java.lang.String getTagName() {
      java.lang.Object ref = "";
      if (revisionCase_ == 4) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 4) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return The bytes for tagName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTagNameBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 4) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 4) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @param value The tagName to set.
     * @return This builder for chaining.
     */
    public Builder setTagName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 4;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagName() {
      if (revisionCase_ == 4) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regex matching tags to build.
     *
     * The syntax of the regular expressions accepted is the syntax accepted by
     * RE2 and described at https://github.com/google/re2/wiki/Syntax
     * </pre>
     *
     * <code>string tag_name = 4;</code>
     *
     * @param value The bytes for tagName to set.
     * @return This builder for chaining.
     */
    public Builder setTagNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 4;
      revision_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return Whether the commitSha field is set.
     */
    @java.lang.Override
    public boolean hasCommitSha() {
      return revisionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return The commitSha.
     */
    @java.lang.Override
    public java.lang.String getCommitSha() {
      java.lang.Object ref = "";
      if (revisionCase_ == 5) {
        ref = revision_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (revisionCase_ == 5) {
          revision_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return The bytes for commitSha.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCommitShaBytes() {
      java.lang.Object ref = "";
      if (revisionCase_ == 5) {
        ref = revision_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (revisionCase_ == 5) {
          revision_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @param value The commitSha to set.
     * @return This builder for chaining.
     */
    public Builder setCommitSha(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionCase_ = 5;
      revision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommitSha() {
      if (revisionCase_ == 5) {
        revisionCase_ = 0;
        revision_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit commit SHA to build.
     * </pre>
     *
     * <code>string commit_sha = 5;</code>
     *
     * @param value The bytes for commitSha to set.
     * @return This builder for chaining.
     */
    public Builder setCommitShaBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionCase_ = 5;
      revision_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the project that owns the Cloud Source Repository. If omitted, the
     * project ID requesting the build is assumed.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object repoName_ = "";
    /**
     *
     *
     * <pre>
     * Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return The repoName.
     */
    public java.lang.String getRepoName() {
      java.lang.Object ref = repoName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        repoName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return The bytes for repoName.
     */
    public com.google.protobuf.ByteString getRepoNameBytes() {
      java.lang.Object ref = repoName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        repoName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @param value The repoName to set.
     * @return This builder for chaining.
     */
    public Builder setRepoName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      repoName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepoName() {
      repoName_ = getDefaultInstance().getRepoName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the Cloud Source Repository.
     * </pre>
     *
     * <code>string repo_name = 2;</code>
     *
     * @param value The bytes for repoName to set.
     * @return This builder for chaining.
     */
    public Builder setRepoNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      repoName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object dir_ = "";
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * eg. helloworld (no leading slash allowed)
     * </pre>
     *
     * <code>string dir = 6;</code>
     *
     * @return The dir.
     */
    public java.lang.String getDir() {
      java.lang.Object ref = dir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * eg. helloworld (no leading slash allowed)
     * </pre>
     *
     * <code>string dir = 6;</code>
     *
     * @return The bytes for dir.
     */
    public com.google.protobuf.ByteString getDirBytes() {
      java.lang.Object ref = dir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * eg. helloworld (no leading slash allowed)
     * </pre>
     *
     * <code>string dir = 6;</code>
     *
     * @param value The dir to set.
     * @return This builder for chaining.
     */
    public Builder setDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dir_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * eg. helloworld (no leading slash allowed)
     * </pre>
     *
     * <code>string dir = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDir() {
      dir_ = getDefaultInstance().getDir();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's `dir` is specified and is an
     * absolute path, this value is ignored for that step's execution.
     * eg. helloworld (no leading slash allowed)
     * </pre>
     *
     * <code>string dir = 6;</code>
     *
     * @param value The bytes for dir to set.
     * @return This builder for chaining.
     */
    public Builder setDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dir_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private boolean invertRegex_;
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 7;</code>
     *
     * @return The invertRegex.
     */
    @java.lang.Override
    public boolean getInvertRegex() {
      return invertRegex_;
    }
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 7;</code>
     *
     * @param value The invertRegex to set.
     * @return This builder for chaining.
     */
    public Builder setInvertRegex(boolean value) {

      invertRegex_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only trigger a build if the revision regex does NOT match the revision
     * regex.
     * </pre>
     *
     * <code>bool invert_regex = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvertRegex() {
      bitField0_ = (bitField0_ & ~0x00000040);
      invertRegex_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2alpha.RepoSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2alpha.RepoSource)
  private static final com.google.cloud.functions.v2alpha.RepoSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2alpha.RepoSource();
  }

  public static com.google.cloud.functions.v2alpha.RepoSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepoSource> PARSER =
      new com.google.protobuf.AbstractParser<RepoSource>() {
        @java.lang.Override
        public RepoSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepoSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepoSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2alpha.RepoSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
