/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/document.proto

// Protobuf Java Version: 3.25.5
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A Firestore document.
 *
 * Must not exceed 1 MiB - 4 bytes.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Document_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetFields();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.DocumentProto
        .internal_static_google_firestore_v1_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.Document.class, com.google.firestore.v1.Document.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the document, for example
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the document, for example
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 2;

  private static final class FieldsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.firestore.v1.Value>newDefaultInstance(
                    com.google.firestore.v1.DocumentProto
                        .internal_static_google_firestore_v1_Document_FieldsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.firestore.v1.Value.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value> fields_;

  private com.google.protobuf.MapField<java.lang.String, com.google.firestore.v1.Value>
      internalGetFields() {
    if (fields_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
    }
    return fields_;
  }

  public int getFieldsCount() {
    return internalGetFields().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The document's fields.
   *
   * The map keys represent field names.
   *
   * Field names matching the regular expression `__.*__` are reserved. Reserved
   * field names are forbidden except in certain documented contexts. The field
   * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
   * empty.
   *
   * Field paths may be used in other contexts to refer to structured fields
   * defined here. For `map_value`, the field path is represented by a
   * dot-delimited (`.`) string of segments. Each segment is either a simple
   * field name (defined below) or a quoted field name. For example, the
   * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
   * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
   *
   * A simple field name contains only characters `a` to `z`, `A` to `Z`,
   * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
   * `foo_bar_17`.
   *
   * A quoted field name starts and ends with `` ` `` and
   * may contain any character. Some characters, including `` ` ``, must be
   * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
   * `` `bak&#92;`tik` `` represents `` bak`tik ``.
   * </pre>
   *
   * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
   */
  @java.lang.Override
  public boolean containsFields(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFields().getMap().containsKey(key);
  }
  /** Use {@link #getFieldsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getFields() {
    return getFieldsMap();
  }
  /**
   *
   *
   * <pre>
   * The document's fields.
   *
   * The map keys represent field names.
   *
   * Field names matching the regular expression `__.*__` are reserved. Reserved
   * field names are forbidden except in certain documented contexts. The field
   * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
   * empty.
   *
   * Field paths may be used in other contexts to refer to structured fields
   * defined here. For `map_value`, the field path is represented by a
   * dot-delimited (`.`) string of segments. Each segment is either a simple
   * field name (defined below) or a quoted field name. For example, the
   * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
   * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
   *
   * A simple field name contains only characters `a` to `z`, `A` to `Z`,
   * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
   * `foo_bar_17`.
   *
   * A quoted field name starts and ends with `` ` `` and
   * may contain any character. Some characters, including `` ` ``, must be
   * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
   * `` `bak&#92;`tik` `` represents `` bak`tik ``.
   * </pre>
   *
   * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getFieldsMap() {
    return internalGetFields().getMap();
  }
  /**
   *
   *
   * <pre>
   * The document's fields.
   *
   * The map keys represent field names.
   *
   * Field names matching the regular expression `__.*__` are reserved. Reserved
   * field names are forbidden except in certain documented contexts. The field
   * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
   * empty.
   *
   * Field paths may be used in other contexts to refer to structured fields
   * defined here. For `map_value`, the field path is represented by a
   * dot-delimited (`.`) string of segments. Each segment is either a simple
   * field name (defined below) or a quoted field name. For example, the
   * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
   * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
   *
   * A simple field name contains only characters `a` to `z`, `A` to `Z`,
   * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
   * `foo_bar_17`.
   *
   * A quoted field name starts and ends with `` ` `` and
   * may contain any character. Some characters, including `` ` ``, must be
   * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
   * `` `bak&#92;`tik` `` represents `` bak`tik ``.
   * </pre>
   *
   * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.firestore.v1.Value getFieldsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.firestore.v1.Value defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
        internalGetFields().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The document's fields.
   *
   * The map keys represent field names.
   *
   * Field names matching the regular expression `__.*__` are reserved. Reserved
   * field names are forbidden except in certain documented contexts. The field
   * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
   * empty.
   *
   * Field paths may be used in other contexts to refer to structured fields
   * defined here. For `map_value`, the field path is represented by a
   * dot-delimited (`.`) string of segments. Each segment is either a simple
   * field name (defined below) or a quoted field name. For example, the
   * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
   * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
   *
   * A simple field name contains only characters `a` to `z`, `A` to `Z`,
   * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
   * `foo_bar_17`.
   *
   * A quoted field name starts and ends with `` ` `` and
   * may contain any character. Some characters, including `` ` ``, must be
   * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
   * `` `bak&#92;`tik` `` represents `` bak`tik ``.
   * </pre>
   *
   * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Value getFieldsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.firestore.v1.Value> map =
        internalGetFields().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was created.
   *
   * This value increases monotonically when a document is deleted then
   * recreated. It can also be compared to values from other documents and
   * the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was created.
   *
   * This value increases monotonically when a document is deleted then
   * recreated. It can also be compared to values from other documents and
   * the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was created.
   *
   * This value increases monotonically when a document is deleted then
   * recreated. It can also be compared to values from other documents and
   * the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was last changed.
   *
   * This value is initially set to the `create_time` then increases
   * monotonically with each change to the document. It can also be
   * compared to values from other documents and the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was last changed.
   *
   * This value is initially set to the `create_time` then increases
   * monotonically with each change to the document. It can also be
   * compared to values from other documents and the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the document was last changed.
   *
   * This value is initially set to the `create_time` then increases
   * monotonically with each change to the document. It can also be
   * compared to values from other documents and the `read_time` of a query.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFields(), FieldsDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> entry :
        internalGetFields().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value> fields__ =
          FieldsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, fields__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.Document)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.Document other = (com.google.firestore.v1.Document) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetFields().equals(other.internalGetFields())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetFields().getMap().isEmpty()) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFields().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.Document parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Document parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Document parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Document parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Document parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Document parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Document parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Document parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Document parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Document parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Document parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Document parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.Document prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Firestore document.
   *
   * Must not exceed 1 MiB - 4 bytes.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Document}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.Document)
      com.google.firestore.v1.DocumentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Document_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Document_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Document.class,
              com.google.firestore.v1.Document.Builder.class);
    }

    // Construct using com.google.firestore.v1.Document.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableFields().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.DocumentProto
          .internal_static_google_firestore_v1_Document_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.Document getDefaultInstanceForType() {
      return com.google.firestore.v1.Document.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.Document build() {
      com.google.firestore.v1.Document result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.Document buildPartial() {
      com.google.firestore.v1.Document result = new com.google.firestore.v1.Document(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.Document result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fields_ = internalGetFields().build(FieldsDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.Document) {
        return mergeFrom((com.google.firestore.v1.Document) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.Document other) {
      if (other == com.google.firestore.v1.Document.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableFields().mergeFrom(other.internalGetFields());
      bitField0_ |= 0x00000002;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
                    fields__ =
                        input.readMessage(
                            FieldsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableFields()
                    .ensureBuilderMap()
                    .put(fields__.getKey(), fields__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the document, for example
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the document, for example
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the document, for example
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the document, for example
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the document, for example
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private static final class FieldsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value> {
      @java.lang.Override
      public com.google.firestore.v1.Value build(com.google.firestore.v1.ValueOrBuilder val) {
        if (val instanceof com.google.firestore.v1.Value) {
          return (com.google.firestore.v1.Value) val;
        }
        return ((com.google.firestore.v1.Value.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<java.lang.String, com.google.firestore.v1.Value>
          defaultEntry() {
        return FieldsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final FieldsConverter fieldsConverter = new FieldsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        fields_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        internalGetFields() {
      if (fields_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(fieldsConverter);
      }
      return fields_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.firestore.v1.ValueOrBuilder,
            com.google.firestore.v1.Value,
            com.google.firestore.v1.Value.Builder>
        internalGetMutableFields() {
      if (fields_ == null) {
        fields_ = new com.google.protobuf.MapFieldBuilder<>(fieldsConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return fields_;
    }

    public int getFieldsCount() {
      return internalGetFields().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    @java.lang.Override
    public boolean containsFields(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFields().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getFieldsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getFields() {
      return getFieldsMap();
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getFieldsMap() {
      return internalGetFields().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.firestore.v1.Value getFieldsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.firestore.v1.Value defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
          internalGetMutableFields().ensureBuilderMap();
      return map.containsKey(key) ? fieldsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Value getFieldsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> map =
          internalGetMutableFields().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return fieldsConverter.build(map.get(key));
    }

    public Builder clearFields() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableFields().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    public Builder removeFields(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFields().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.firestore.v1.Value> getMutableFields() {
      bitField0_ |= 0x00000002;
      return internalGetMutableFields().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    public Builder putFields(java.lang.String key, com.google.firestore.v1.Value value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableFields().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    public Builder putAllFields(
        java.util.Map<java.lang.String, com.google.firestore.v1.Value> values) {
      for (java.util.Map.Entry<java.lang.String, com.google.firestore.v1.Value> e :
          values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableFields().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document's fields.
     *
     * The map keys represent field names.
     *
     * Field names matching the regular expression `__.*__` are reserved. Reserved
     * field names are forbidden except in certain documented contexts. The field
     * names, represented as UTF-8, must not exceed 1,500 bytes and cannot be
     * empty.
     *
     * Field paths may be used in other contexts to refer to structured fields
     * defined here. For `map_value`, the field path is represented by a
     * dot-delimited (`.`) string of segments. Each segment is either a simple
     * field name (defined below) or a quoted field name. For example, the
     * structured field `"foo" : { map_value: { "x&amp;y" : { string_value: "hello"
     * }}}` would be represented by the field path `` foo.`x&amp;y` ``.
     *
     * A simple field name contains only characters `a` to `z`, `A` to `Z`,
     * `0` to `9`, or `_`, and must not start with `0` to `9`. For example,
     * `foo_bar_17`.
     *
     * A quoted field name starts and ends with `` ` `` and
     * may contain any character. Some characters, including `` ` ``, must be
     * escaped using a `&#92;`. For example, `` `x&amp;y` `` represents `x&amp;y` and
     * `` `bak&#92;`tik` `` represents `` bak`tik ``.
     * </pre>
     *
     * <code>map&lt;string, .google.firestore.v1.Value&gt; fields = 2;</code>
     */
    public com.google.firestore.v1.Value.Builder putFieldsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<java.lang.String, com.google.firestore.v1.ValueOrBuilder> builderMap =
          internalGetMutableFields().ensureBuilderMap();
      com.google.firestore.v1.ValueOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.firestore.v1.Value.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.firestore.v1.Value) {
        entry = ((com.google.firestore.v1.Value) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.firestore.v1.Value.Builder) entry;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was created.
     *
     * This value increases monotonically when a document is deleted then
     * recreated. It can also be compared to values from other documents and
     * the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the document was last changed.
     *
     * This value is initially set to the `create_time` then increases
     * monotonically with each change to the document. It can also be
     * compared to values from other documents and the `read_time` of a query.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.Document)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.Document)
  private static final com.google.firestore.v1.Document DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.Document();
  }

  public static com.google.firestore.v1.Document getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Document> PARSER =
      new com.google.protobuf.AbstractParser<Document>() {
        @java.lang.Override
        public Document parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Document> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Document> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.Document getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
