/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.3
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The streamed response for
 * [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.BatchGetDocumentsResponse}
 */
public final class BatchGetDocumentsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.BatchGetDocumentsResponse)
    BatchGetDocumentsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchGetDocumentsResponse.newBuilder() to construct.
  private BatchGetDocumentsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchGetDocumentsResponse() {
    transaction_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchGetDocumentsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchGetDocumentsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchGetDocumentsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.BatchGetDocumentsResponse.class,
            com.google.firestore.v1.BatchGetDocumentsResponse.Builder.class);
  }

  private int bitField0_;
  private int resultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FOUND(1),
    MISSING(2),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 1:
          return FOUND;
        case 2:
          return MISSING;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int FOUND_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A document that was requested.
   * </pre>
   *
   * <code>.google.firestore.v1.Document found = 1;</code>
   *
   * @return Whether the found field is set.
   */
  @java.lang.Override
  public boolean hasFound() {
    return resultCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A document that was requested.
   * </pre>
   *
   * <code>.google.firestore.v1.Document found = 1;</code>
   *
   * @return The found.
   */
  @java.lang.Override
  public com.google.firestore.v1.Document getFound() {
    if (resultCase_ == 1) {
      return (com.google.firestore.v1.Document) result_;
    }
    return com.google.firestore.v1.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A document that was requested.
   * </pre>
   *
   * <code>.google.firestore.v1.Document found = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentOrBuilder getFoundOrBuilder() {
    if (resultCase_ == 1) {
      return (com.google.firestore.v1.Document) result_;
    }
    return com.google.firestore.v1.Document.getDefaultInstance();
  }

  public static final int MISSING_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A document name that was requested but does not exist. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string missing = 2;</code>
   *
   * @return Whether the missing field is set.
   */
  public boolean hasMissing() {
    return resultCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A document name that was requested but does not exist. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string missing = 2;</code>
   *
   * @return The missing.
   */
  public java.lang.String getMissing() {
    java.lang.Object ref = "";
    if (resultCase_ == 2) {
      ref = result_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (resultCase_ == 2) {
        result_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A document name that was requested but does not exist. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * </pre>
   *
   * <code>string missing = 2;</code>
   *
   * @return The bytes for missing.
   */
  public com.google.protobuf.ByteString getMissingBytes() {
    java.lang.Object ref = "";
    if (resultCase_ == 2) {
      ref = result_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (resultCase_ == 2) {
        result_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSACTION_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The transaction that was started as part of this request.
   * Will only be set in the first response, and only if
   * [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction]
   * was set in the request.
   * </pre>
   *
   * <code>bytes transaction = 3;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    return transaction_;
  }

  public static final int READ_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * The time at which the document was read.
   * This may be monotically increasing, in this case the previous documents in
   * the result stream are guaranteed not to have changed between their
   * read_time and this one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the document was read.
   * This may be monotically increasing, in this case the previous documents in
   * the result stream are guaranteed not to have changed between their
   * read_time and this one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the document was read.
   * This may be monotically increasing, in this case the previous documents in
   * the result stream are guaranteed not to have changed between their
   * read_time and this one.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resultCase_ == 1) {
      output.writeMessage(1, (com.google.firestore.v1.Document) result_);
    }
    if (resultCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, result_);
    }
    if (!transaction_.isEmpty()) {
      output.writeBytes(3, transaction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getReadTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resultCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.firestore.v1.Document) result_);
    }
    if (resultCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, result_);
    }
    if (!transaction_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, transaction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReadTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.BatchGetDocumentsResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.BatchGetDocumentsResponse other =
        (com.google.firestore.v1.BatchGetDocumentsResponse) obj;

    if (!getTransaction().equals(other.getTransaction())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 1:
        if (!getFound().equals(other.getFound())) return false;
        break;
      case 2:
        if (!getMissing().equals(other.getMissing())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
    hash = (53 * hash) + getTransaction().hashCode();
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    switch (resultCase_) {
      case 1:
        hash = (37 * hash) + FOUND_FIELD_NUMBER;
        hash = (53 * hash) + getFound().hashCode();
        break;
      case 2:
        hash = (37 * hash) + MISSING_FIELD_NUMBER;
        hash = (53 * hash) + getMissing().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.BatchGetDocumentsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The streamed response for
   * [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.BatchGetDocumentsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.BatchGetDocumentsResponse)
      com.google.firestore.v1.BatchGetDocumentsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.BatchGetDocumentsResponse.class,
              com.google.firestore.v1.BatchGetDocumentsResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1.BatchGetDocumentsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReadTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (foundBuilder_ != null) {
        foundBuilder_.clear();
      }
      transaction_ = com.google.protobuf.ByteString.EMPTY;
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsResponse getDefaultInstanceForType() {
      return com.google.firestore.v1.BatchGetDocumentsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsResponse build() {
      com.google.firestore.v1.BatchGetDocumentsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsResponse buildPartial() {
      com.google.firestore.v1.BatchGetDocumentsResponse result =
          new com.google.firestore.v1.BatchGetDocumentsResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.BatchGetDocumentsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.transaction_ = transaction_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.BatchGetDocumentsResponse result) {
      result.resultCase_ = resultCase_;
      result.result_ = this.result_;
      if (resultCase_ == 1 && foundBuilder_ != null) {
        result.result_ = foundBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.BatchGetDocumentsResponse) {
        return mergeFrom((com.google.firestore.v1.BatchGetDocumentsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.BatchGetDocumentsResponse other) {
      if (other == com.google.firestore.v1.BatchGetDocumentsResponse.getDefaultInstance())
        return this;
      if (other.getTransaction() != com.google.protobuf.ByteString.EMPTY) {
        setTransaction(other.getTransaction());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      switch (other.getResultCase()) {
        case FOUND:
          {
            mergeFound(other.getFound());
            break;
          }
        case MISSING:
          {
            resultCase_ = 2;
            result_ = other.result_;
            onChanged();
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getFoundFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                resultCase_ = 2;
                result_ = s;
                break;
              } // case 18
            case 26:
              {
                transaction_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        foundBuilder_;
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     *
     * @return Whether the found field is set.
     */
    @java.lang.Override
    public boolean hasFound() {
      return resultCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     *
     * @return The found.
     */
    @java.lang.Override
    public com.google.firestore.v1.Document getFound() {
      if (foundBuilder_ == null) {
        if (resultCase_ == 1) {
          return (com.google.firestore.v1.Document) result_;
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      } else {
        if (resultCase_ == 1) {
          return foundBuilder_.getMessage();
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    public Builder setFound(com.google.firestore.v1.Document value) {
      if (foundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        foundBuilder_.setMessage(value);
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    public Builder setFound(com.google.firestore.v1.Document.Builder builderForValue) {
      if (foundBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        foundBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    public Builder mergeFound(com.google.firestore.v1.Document value) {
      if (foundBuilder_ == null) {
        if (resultCase_ == 1 && result_ != com.google.firestore.v1.Document.getDefaultInstance()) {
          result_ =
              com.google.firestore.v1.Document.newBuilder(
                      (com.google.firestore.v1.Document) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 1) {
          foundBuilder_.mergeFrom(value);
        } else {
          foundBuilder_.setMessage(value);
        }
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    public Builder clearFound() {
      if (foundBuilder_ == null) {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
        }
        foundBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    public com.google.firestore.v1.Document.Builder getFoundBuilder() {
      return getFoundFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentOrBuilder getFoundOrBuilder() {
      if ((resultCase_ == 1) && (foundBuilder_ != null)) {
        return foundBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 1) {
          return (com.google.firestore.v1.Document) result_;
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document that was requested.
     * </pre>
     *
     * <code>.google.firestore.v1.Document found = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        getFoundFieldBuilder() {
      if (foundBuilder_ == null) {
        if (!(resultCase_ == 1)) {
          result_ = com.google.firestore.v1.Document.getDefaultInstance();
        }
        foundBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Document,
                com.google.firestore.v1.Document.Builder,
                com.google.firestore.v1.DocumentOrBuilder>(
                (com.google.firestore.v1.Document) result_, getParentForChildren(), isClean());
        result_ = null;
      }
      resultCase_ = 1;
      onChanged();
      return foundBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @return Whether the missing field is set.
     */
    @java.lang.Override
    public boolean hasMissing() {
      return resultCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @return The missing.
     */
    @java.lang.Override
    public java.lang.String getMissing() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 2) {
          result_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @return The bytes for missing.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMissingBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (resultCase_ == 2) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @param value The missing to set.
     * @return This builder for chaining.
     */
    public Builder setMissing(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resultCase_ = 2;
      result_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMissing() {
      if (resultCase_ == 2) {
        resultCase_ = 0;
        result_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document name that was requested but does not exist. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * </pre>
     *
     * <code>string missing = 2;</code>
     *
     * @param value The bytes for missing to set.
     * @return This builder for chaining.
     */
    public Builder setMissingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resultCase_ = 2;
      result_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Will only be set in the first response, and only if
     * [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction]
     * was set in the request.
     * </pre>
     *
     * <code>bytes transaction = 3;</code>
     *
     * @return The transaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTransaction() {
      return transaction_;
    }
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Will only be set in the first response, and only if
     * [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction]
     * was set in the request.
     * </pre>
     *
     * <code>bytes transaction = 3;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transaction_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Will only be set in the first response, and only if
     * [BatchGetDocumentsRequest.new_transaction][google.firestore.v1.BatchGetDocumentsRequest.new_transaction]
     * was set in the request.
     * </pre>
     *
     * <code>bytes transaction = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      transaction_ = getDefaultInstance().getTransaction();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
      } else {
        readTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && readTime_ != null
            && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReadTimeBuilder().mergeFrom(value);
        } else {
          readTime_ = value;
        }
      } else {
        readTimeBuilder_.mergeFrom(value);
      }
      if (readTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public Builder clearReadTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read.
     * This may be monotically increasing, in this case the previous documents in
     * the result stream are guaranteed not to have changed between their
     * read_time and this one.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.BatchGetDocumentsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.BatchGetDocumentsResponse)
  private static final com.google.firestore.v1.BatchGetDocumentsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.BatchGetDocumentsResponse();
  }

  public static com.google.firestore.v1.BatchGetDocumentsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchGetDocumentsResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchGetDocumentsResponse>() {
        @java.lang.Override
        public BatchGetDocumentsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchGetDocumentsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchGetDocumentsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.BatchGetDocumentsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
