/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserCredsName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE_USER_CREDS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/userCreds/{user_creds}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String userCreds;

    @Deprecated
    protected UserCredsName() {
        this.project = null;
        this.database = null;
        this.userCreds = null;
    }

    private UserCredsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.userCreds = (String)Preconditions.checkNotNull((Object)builder.getUserCreds());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUserCreds() {
        return this.userCreds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserCredsName of(String project, String database, String userCreds) {
        return UserCredsName.newBuilder().setProject(project).setDatabase(database).setUserCreds(userCreds).build();
    }

    public static String format(String project, String database, String userCreds) {
        return UserCredsName.newBuilder().setProject(project).setDatabase(database).setUserCreds(userCreds).build().toString();
    }

    public static UserCredsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE_USER_CREDS.validatedMatch(formattedString, "UserCredsName.parse: formattedString not in valid format");
        return UserCredsName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("user_creds"));
    }

    public static List<UserCredsName> parseList(List<String> formattedStrings) {
        ArrayList<UserCredsName> list = new ArrayList<UserCredsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserCredsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserCredsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserCredsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE_USER_CREDS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserCredsName userCredsName = this;
            synchronized (userCredsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.userCreds != null) {
                        fieldMapBuilder.put((Object)"user_creds", (Object)this.userCreds);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE_USER_CREDS.instantiate(new String[]{"project", this.project, "database", this.database, "user_creds", this.userCreds});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserCredsName that = (UserCredsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database) && Objects.equals(this.userCreds, that.userCreds);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userCreds);
    }

    public static class Builder {
        private String project;
        private String database;
        private String userCreds;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getUserCreds() {
            return this.userCreds;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setUserCreds(String userCreds) {
            this.userCreds = userCreds;
            return this;
        }

        private Builder(UserCredsName userCredsName) {
            this.project = userCredsName.project;
            this.database = userCredsName.database;
            this.userCreds = userCredsName.userCreds;
        }

        public UserCredsName build() {
            return new UserCredsName(this);
        }
    }
}

