/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupScheduleName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE_BACKUP_SCHEDULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/backupSchedules/{backup_schedule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String backupSchedule;

    @Deprecated
    protected BackupScheduleName() {
        this.project = null;
        this.database = null;
        this.backupSchedule = null;
    }

    private BackupScheduleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.backupSchedule = (String)Preconditions.checkNotNull((Object)builder.getBackupSchedule());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getBackupSchedule() {
        return this.backupSchedule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupScheduleName of(String project, String database, String backupSchedule) {
        return BackupScheduleName.newBuilder().setProject(project).setDatabase(database).setBackupSchedule(backupSchedule).build();
    }

    public static String format(String project, String database, String backupSchedule) {
        return BackupScheduleName.newBuilder().setProject(project).setDatabase(database).setBackupSchedule(backupSchedule).build().toString();
    }

    public static BackupScheduleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE_BACKUP_SCHEDULE.validatedMatch(formattedString, "BackupScheduleName.parse: formattedString not in valid format");
        return BackupScheduleName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("backup_schedule"));
    }

    public static List<BackupScheduleName> parseList(List<String> formattedStrings) {
        ArrayList<BackupScheduleName> list = new ArrayList<BackupScheduleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupScheduleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupScheduleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupScheduleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE_BACKUP_SCHEDULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupScheduleName backupScheduleName = this;
            synchronized (backupScheduleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.backupSchedule != null) {
                        fieldMapBuilder.put((Object)"backup_schedule", (Object)this.backupSchedule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE_BACKUP_SCHEDULE.instantiate(new String[]{"project", this.project, "database", this.database, "backup_schedule", this.backupSchedule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupScheduleName that = (BackupScheduleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database) && Objects.equals(this.backupSchedule, that.backupSchedule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupSchedule);
    }

    public static class Builder {
        private String project;
        private String database;
        private String backupSchedule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getBackupSchedule() {
            return this.backupSchedule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setBackupSchedule(String backupSchedule) {
            this.backupSchedule = backupSchedule;
            return this;
        }

        private Builder(BackupScheduleName backupScheduleName) {
            this.project = backupScheduleName.project;
            this.database = backupScheduleName.database;
            this.backupSchedule = backupScheduleName.backupSchedule;
        }

        public BackupScheduleName build() {
            return new BackupScheduleName(this);
        }
    }
}

