/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EngineVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_ENGINE_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String engineVersion;

    @Deprecated
    protected EngineVersionName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.engineVersion = null;
    }

    private EngineVersionName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.engineVersion = (String)Preconditions.checkNotNull((Object)builder.getEngineVersion());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EngineVersionName of(String projectNum, String location, String instance, String engineVersion) {
        return EngineVersionName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setEngineVersion(engineVersion).build();
    }

    public static String format(String projectNum, String location, String instance, String engineVersion) {
        return EngineVersionName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setEngineVersion(engineVersion).build().toString();
    }

    public static EngineVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_ENGINE_VERSION.validatedMatch(formattedString, "EngineVersionName.parse: formattedString not in valid format");
        return EngineVersionName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("engine_version"));
    }

    public static List<EngineVersionName> parseList(List<String> formattedStrings) {
        ArrayList<EngineVersionName> list = new ArrayList<EngineVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EngineVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EngineVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EngineVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_ENGINE_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EngineVersionName engineVersionName = this;
            synchronized (engineVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.engineVersion != null) {
                        fieldMapBuilder.put((Object)"engine_version", (Object)this.engineVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_ENGINE_VERSION.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "engine_version", this.engineVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EngineVersionName that = (EngineVersionName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.engineVersion, that.engineVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engineVersion);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String engineVersion;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        private Builder(EngineVersionName engineVersionName) {
            this.projectNum = engineVersionName.projectNum;
            this.location = engineVersionName.location;
            this.instance = engineVersionName.instance;
            this.engineVersion = engineVersionName.engineVersion;
        }

        public EngineVersionName build() {
            return new EngineVersionName(this);
        }
    }
}

