/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BacktestResultName
implements ResourceName {
    private static final PathTemplate PROJECT_NUM_LOCATION_INSTANCE_BACKTEST_RESULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_num}/locations/{location}/instances/{instance}/backtestResults/{backtest_result}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNum;
    private final String location;
    private final String instance;
    private final String backtestResult;

    @Deprecated
    protected BacktestResultName() {
        this.projectNum = null;
        this.location = null;
        this.instance = null;
        this.backtestResult = null;
    }

    private BacktestResultName(Builder builder) {
        this.projectNum = (String)Preconditions.checkNotNull((Object)builder.getProjectNum());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.backtestResult = (String)Preconditions.checkNotNull((Object)builder.getBacktestResult());
    }

    public String getProjectNum() {
        return this.projectNum;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getBacktestResult() {
        return this.backtestResult;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BacktestResultName of(String projectNum, String location, String instance, String backtestResult) {
        return BacktestResultName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setBacktestResult(backtestResult).build();
    }

    public static String format(String projectNum, String location, String instance, String backtestResult) {
        return BacktestResultName.newBuilder().setProjectNum(projectNum).setLocation(location).setInstance(instance).setBacktestResult(backtestResult).build().toString();
    }

    public static BacktestResultName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUM_LOCATION_INSTANCE_BACKTEST_RESULT.validatedMatch(formattedString, "BacktestResultName.parse: formattedString not in valid format");
        return BacktestResultName.of((String)matchMap.get("project_num"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("backtest_result"));
    }

    public static List<BacktestResultName> parseList(List<String> formattedStrings) {
        ArrayList<BacktestResultName> list = new ArrayList<BacktestResultName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BacktestResultName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BacktestResultName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BacktestResultName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUM_LOCATION_INSTANCE_BACKTEST_RESULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BacktestResultName backtestResultName = this;
            synchronized (backtestResultName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNum != null) {
                        fieldMapBuilder.put((Object)"project_num", (Object)this.projectNum);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.backtestResult != null) {
                        fieldMapBuilder.put((Object)"backtest_result", (Object)this.backtestResult);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUM_LOCATION_INSTANCE_BACKTEST_RESULT.instantiate(new String[]{"project_num", this.projectNum, "location", this.location, "instance", this.instance, "backtest_result", this.backtestResult});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BacktestResultName that = (BacktestResultName)o;
            return Objects.equals(this.projectNum, that.projectNum) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.backtestResult, that.backtestResult);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNum);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backtestResult);
    }

    public static class Builder {
        private String projectNum;
        private String location;
        private String instance;
        private String backtestResult;

        protected Builder() {
        }

        public String getProjectNum() {
            return this.projectNum;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getBacktestResult() {
            return this.backtestResult;
        }

        public Builder setProjectNum(String projectNum) {
            this.projectNum = projectNum;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setBacktestResult(String backtestResult) {
            this.backtestResult = backtestResult;
            return this;
        }

        private Builder(BacktestResultName backtestResultName) {
            this.projectNum = backtestResultName.projectNum;
            this.location = backtestResultName.location;
            this.instance = backtestResultName.instance;
            this.backtestResult = backtestResultName.backtestResult;
        }

        public BacktestResultName build() {
            return new BacktestResultName(this);
        }
    }
}

